/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.execution.ExecutionCallback;
import org.mule.execution.ExecutionContext;
import org.mule.execution.ExecutionInterceptor;
import org.mule.transaction.TransactionCoordination;

class CommitTransactionInterceptor
implements ExecutionInterceptor<MuleEvent> {
    private final ExecutionInterceptor<MuleEvent> nextInterceptor;

    public CommitTransactionInterceptor(ExecutionInterceptor<MuleEvent> nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    @Override
    public MuleEvent execute(ExecutionCallback<MuleEvent> callback, ExecutionContext executionContext) throws Exception {
        MuleEvent result = this.nextInterceptor.execute(callback, executionContext);
        if (executionContext.needsTransactionResolution()) {
            try {
                TransactionCoordination.getInstance().resolveTransaction();
            }
            catch (Exception e) {
                if (result == null || VoidMuleEvent.getInstance().equals(result)) {
                    result = RequestContext.getEvent();
                }
                throw new MessagingException(result, (Throwable)e);
            }
        }
        return result;
    }
}

