/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import javax.resource.spi.work.Work;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.exception.RollbackSourceCallback;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.exception.AbstractExceptionListener;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectException;

public class AbstractSystemExceptionStrategy
extends AbstractExceptionListener
implements SystemExceptionHandler {
    public AbstractSystemExceptionStrategy(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public void handleException(Exception ex, RollbackSourceCallback rollbackMethod) {
        this.fireNotification(ex);
        this.doLogException(ex);
        if (this.isRollback(ex)) {
            this.logger.debug((Object)"Rolling back transaction");
            this.rollback(ex, rollbackMethod);
        } else {
            this.logger.debug((Object)"Committing transaction");
            this.commit();
        }
        DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload(ex);
        if (RequestContext.getEvent() != null) {
            RequestContext.setExceptionPayload(exceptionPayload);
        }
        if (ex instanceof ConnectException) {
            this.handleReconnection((ConnectException)ex);
        }
    }

    private void rollback(Exception ex, RollbackSourceCallback rollbackMethod) {
        if (TransactionCoordination.getInstance().getTransaction() != null) {
            this.rollback(ex);
        }
        if (rollbackMethod != null) {
            rollbackMethod.rollback();
        }
    }

    @Override
    public void handleException(Exception ex) {
        this.handleException(ex, null);
    }

    protected void handleReconnection(ConnectException ex) {
        final AbstractConnector connector = (AbstractConnector)ex.getFailed();
        if (connector.isConnecting()) {
            return;
        }
        this.logger.info((Object)"Exception caught is a ConnectException, attempting to reconnect...");
        try {
            this.logger.debug((Object)("Stopping " + connector.getName()));
            connector.stop();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        try {
            this.logger.debug((Object)("Disconnecting " + connector.getName()));
            connector.disconnect();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        try {
            connector.getMuleContext().getWorkManager().scheduleWork(new Work(){

                public void release() {
                }

                public void run() {
                    try {
                        AbstractSystemExceptionStrategy.this.logger.debug((Object)("Reconnecting " + connector.getName()));
                        connector.start();
                    }
                    catch (Exception e) {
                        if (AbstractSystemExceptionStrategy.this.logger.isDebugEnabled()) {
                            AbstractSystemExceptionStrategy.this.logger.debug((Object)"Error reconnecting", (Throwable)e);
                        }
                        AbstractSystemExceptionStrategy.this.logger.error((Object)e.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Error executing reconnect work", (Throwable)e);
            }
            this.logger.error((Object)e.getMessage());
        }
    }
}

