/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.Connector;
import org.mule.config.ExceptionHelper;
import org.mule.util.ObjectUtils;

public class InboundExceptionDetailsMessageProcessor
implements MessageProcessor,
MuleContextAware {
    private static final Log logger = LogFactory.getLog(InboundExceptionDetailsMessageProcessor.class);
    protected Connector connector;
    private MuleContext muleContext;

    public InboundExceptionDetailsMessageProcessor(Connector connector) {
        this.connector = connector;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage resultMessage;
        if (event != null && !VoidMuleEvent.getInstance().equals(event) && (resultMessage = event.getMessage()) != null && resultMessage.getExceptionPayload() != null) {
            this.setExceptionDetails(resultMessage, this.connector, resultMessage.getExceptionPayload().getException());
        }
        return event;
    }

    protected void setExceptionDetails(MuleMessage message, Connector connector, Throwable exception) {
        String propName = ExceptionHelper.getErrorCodePropertyName(connector.getProtocol(), this.muleContext);
        if (propName != null) {
            String code = ExceptionHelper.getErrorMapping(connector.getProtocol(), exception.getClass(), this.muleContext);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting error code for: " + connector.getProtocol() + ", " + propName + "=" + code));
            }
            message.setOutboundProperty(propName, code);
        }
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

