/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.EndpointURIBuilder;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.api.util.CredentialsMaskUtil;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.ClassUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public class MuleEndpointURI
implements EndpointURI {
    private static final long serialVersionUID = 3906735768171252877L;
    protected static final Log logger = LogFactory.getLog(MuleEndpointURI.class);
    public static final String PASSWORD_MASK = "****";
    private String address;
    private String filterAddress;
    private String endpointName;
    private String connectorName;
    private String transformers;
    private String responseTransformers;
    private Properties params = new Properties();
    private URI uri;
    private String userInfo;
    private String schemeMetaInfo;
    private String resourceInfo;
    private boolean dynamic;
    private transient MuleContext muleContext;
    private Properties serviceOverrides;
    private String user;
    private String password;

    public static boolean isMuleUri(String url) {
        return url.indexOf(":/") != -1;
    }

    MuleEndpointURI(String address, String endpointName, String connectorName, String transformers, String responseTransformers, Properties properties, URI uri, String userInfo, MuleContext muleContext) {
        this(address, endpointName, connectorName, transformers, responseTransformers, properties, uri, muleContext);
        if (userInfo != null) {
            this.userInfo = userInfo;
        }
    }

    public MuleEndpointURI(String address, String endpointName, String connectorName, String transformers, String responseTransformers, Properties properties, URI uri, MuleContext muleContext) {
        this.address = address;
        this.endpointName = endpointName;
        this.connectorName = connectorName;
        this.transformers = transformers;
        this.responseTransformers = responseTransformers;
        this.params = properties;
        this.uri = uri;
        this.userInfo = uri.getUserInfo();
        this.muleContext = muleContext;
        if (properties != null) {
            this.resourceInfo = (String)properties.remove("resourceInfo");
        }
    }

    public MuleEndpointURI(EndpointURI endpointUri) {
        this.initialise(endpointUri);
    }

    public MuleEndpointURI(EndpointURI endpointUri, String filterAddress) {
        this.initialise(endpointUri);
        this.filterAddress = filterAddress;
    }

    public MuleEndpointURI(String uri, MuleContext muleContext) throws EndpointException {
        this(uri, null, muleContext);
    }

    public MuleEndpointURI(String uri, MuleContext muleContext, Properties serviceOverrides) throws EndpointException {
        this(uri, null, muleContext);
        this.serviceOverrides = serviceOverrides;
    }

    public MuleEndpointURI(String uri, String encodedUri, MuleContext muleContext) throws EndpointException {
        this.muleContext = muleContext;
        String startUri = uri = this.preprocessUri(uri);
        uri = this.convertExpressionDelimiters(uri, "#");
        uri = this.convertExpressionDelimiters(uri, "$");
        if (uri.indexOf("#[") >= 0) {
            this.address = uri;
            this.dynamic = true;
        } else {
            try {
                this.uri = new URI(encodedUri != null && uri.equals(startUri) ? this.preprocessUri(encodedUri) : uri);
            }
            catch (URISyntaxException e) {
                throw new MalformedEndpointException(uri, (Throwable)e);
            }
            this.userInfo = this.uri.getUserInfo();
        }
    }

    private String convertExpressionDelimiters(String uriString, String startChar) {
        int uriLength = uriString.length();
        block0: for (int index = 0; index < uriLength && (index = uriString.indexOf(startChar + "{", index)) >= 0; index += 2) {
            int braceCount = 1;
            for (int seek = index + 2; seek < uriLength; ++seek) {
                char c = uriString.charAt(seek);
                if (c == '{') {
                    ++braceCount;
                    continue;
                }
                if (c != '}' || --braceCount != 0) continue;
                uriString = uriString.substring(0, index) + startChar + "[" + uriString.substring(index + 2, seek) + "]" + uriString.substring(seek + 1);
                continue block0;
            }
        }
        return uriString;
    }

    protected String preprocessUri(String uriString) throws MalformedEndpointException {
        if (!this.validateUrl(uriString = uriString.trim().replaceAll(" ", "%20"))) {
            throw new MalformedEndpointException(uriString);
        }
        this.schemeMetaInfo = this.retrieveSchemeMetaInfo(uriString);
        if (this.schemeMetaInfo != null) {
            uriString = uriString.replaceFirst(this.schemeMetaInfo + ":", "");
        }
        return uriString;
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            String scheme = this.getFullScheme();
            TransportServiceDescriptor sd = (TransportServiceDescriptor)this.muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, scheme, this.serviceOverrides);
            if (sd == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
            }
            EndpointURIBuilder builder = sd.createEndpointURIBuilder();
            EndpointURI built = builder.build(this.uri, this.muleContext);
            this.initialise(built);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private String retrieveSchemeMetaInfo(String url) {
        int i = url.indexOf(58);
        if (i == -1) {
            return null;
        }
        if (url.charAt(i + 1) == '/') {
            return null;
        }
        return url.substring(0, i);
    }

    protected boolean validateUrl(String url) {
        return url.indexOf(":/") > 0;
    }

    private void initialise(EndpointURI endpointUri) {
        this.address = endpointUri.getAddress();
        if (this.endpointName == null) {
            this.endpointName = endpointUri.getEndpointName();
        }
        this.connectorName = endpointUri.getConnectorName();
        this.transformers = endpointUri.getTransformers();
        this.responseTransformers = endpointUri.getResponseTransformers();
        this.params = endpointUri.getParams();
        this.uri = endpointUri.getUri();
        this.resourceInfo = endpointUri.getResourceInfo();
        this.userInfo = endpointUri.getUserInfo();
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getEndpointName() {
        return StringUtils.isEmpty((String)this.endpointName) ? null : this.endpointName;
    }

    @Override
    public Properties getParams() {
        if (this.params.size() == 0 && this.getQuery() != null) {
            this.params = PropertiesUtils.getPropertiesFromQueryString(this.getQuery());
        }
        return this.params;
    }

    @Override
    public Properties getUserParams() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.getParams());
        p.remove("endpointName");
        p.remove("address");
        p.remove("transformers");
        return p;
    }

    public URI parseServerAuthority() throws URISyntaxException {
        return this.uri.parseServerAuthority();
    }

    public URI normalize() {
        return this.uri.normalize();
    }

    public URI resolve(URI uri) {
        return uri.resolve(uri);
    }

    public URI resolve(String str) {
        return this.uri.resolve(str);
    }

    public URI relativize(URI uri) {
        return uri.relativize(uri);
    }

    @Override
    public String getScheme() {
        return this.isDynamic() ? this.getDynamicScheme() : this.uri.getScheme();
    }

    private String getDynamicScheme() {
        int colon = this.address.indexOf(58);
        return this.address.substring(0, colon);
    }

    @Override
    public String getFullScheme() {
        String scheme = this.dynamic ? this.getDynamicScheme() : this.uri.getScheme();
        return this.schemeMetaInfo == null ? scheme : this.schemeMetaInfo + ':' + scheme;
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    public boolean isOpaque() {
        return this.uri.isOpaque();
    }

    public String getRawSchemeSpecificPart() {
        return this.uri.getRawSchemeSpecificPart();
    }

    public String getSchemeSpecificPart() {
        return this.uri.getSchemeSpecificPart();
    }

    public String getRawAuthority() {
        return this.uri.getRawAuthority();
    }

    @Override
    public String getAuthority() {
        return this.uri.getAuthority();
    }

    public String getRawUserInfo() {
        return this.uri.getRawUserInfo();
    }

    @Override
    public String getUserInfo() {
        return this.userInfo;
    }

    @Override
    public String getHost() {
        return this.uri.getHost();
    }

    @Override
    public int getPort() {
        return this.uri.getPort();
    }

    public String getRawPath() {
        return this.uri.getRawPath();
    }

    @Override
    public String getPath() {
        return this.uri.getPath();
    }

    public String getRawQuery() {
        return this.uri.getRawQuery();
    }

    @Override
    public String getQuery() {
        return this.uri.getQuery();
    }

    public String getRawFragment() {
        return this.uri.getRawFragment();
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public String toString() {
        return CredentialsMaskUtil.maskUrlPasswordWithMask(this.uri.toASCIIString(), CredentialsMaskUtil.BARE_URL_PASSWORD_PATTERN, PASSWORD_MASK);
    }

    protected String createUriStringWithPasswordMasked() {
        String rawUserInfo = this.uri.getRawUserInfo();
        if (StringUtils.isBlank((String)rawUserInfo)) {
            rawUserInfo = this.userInfo;
        }
        String maskedUserInfo = null;
        int index = rawUserInfo.indexOf(":");
        if (index > -1) {
            maskedUserInfo = rawUserInfo.substring(0, index);
        }
        maskedUserInfo = maskedUserInfo + ":****";
        return this.uri.toASCIIString().replace(rawUserInfo, maskedUserInfo);
    }

    @Override
    public String getTransformers() {
        return this.transformers;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getConnectorName() {
        return this.connectorName;
    }

    @Override
    public String getSchemeMetaInfo() {
        return this.schemeMetaInfo == null ? this.uri.getScheme() : this.schemeMetaInfo;
    }

    @Override
    public String getResourceInfo() {
        return this.resourceInfo;
    }

    @Override
    public String getFilterAddress() {
        return this.filterAddress;
    }

    @Override
    public String getUser() {
        if (this.user == null) {
            this.user = this.getUserInfoDataUsing(new DataExtractor(){

                @Override
                public String extract(String source) {
                    int i = source.indexOf(58);
                    if (i == -1) {
                        return source;
                    }
                    return source.substring(0, i);
                }
            });
        }
        return this.user;
    }

    @Override
    public String getPassword() {
        if (this.password == null) {
            this.password = this.getUserInfoDataUsing(new DataExtractor(){

                @Override
                public String extract(String source) {
                    int i = source.indexOf(58);
                    if (i > -1) {
                        return source.substring(i + 1);
                    }
                    return null;
                }
            });
        }
        return this.password;
    }

    private String getUserInfoDataUsing(DataExtractor extractor) {
        String userInfoData = this.getRawUserInfo();
        boolean decode = true;
        if (userInfoData == null) {
            userInfoData = this.userInfo;
            decode = false;
        }
        String data = null;
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)userInfoData)) {
            data = extractor.extract(userInfoData);
        }
        return data != null && decode ? URLDecoder.decode(data) : data;
    }

    @Override
    public String getResponseTransformers() {
        return this.responseTransformers;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleEndpointURI)) {
            return false;
        }
        MuleEndpointURI muleEndpointURI = (MuleEndpointURI)o;
        return ClassUtils.equal(this.address, muleEndpointURI.address) && ClassUtils.equal(this.connectorName, muleEndpointURI.connectorName) && ClassUtils.equal(this.endpointName, muleEndpointURI.endpointName) && ClassUtils.equal(this.filterAddress, muleEndpointURI.filterAddress) && this.areParamsEquals(muleEndpointURI.params) && ClassUtils.equal(this.resourceInfo, muleEndpointURI.resourceInfo) && ClassUtils.equal(this.schemeMetaInfo, muleEndpointURI.schemeMetaInfo) && ClassUtils.equal(this.transformers, muleEndpointURI.transformers) && ClassUtils.equal(this.responseTransformers, muleEndpointURI.responseTransformers) && ClassUtils.equal(this.uri, muleEndpointURI.uri);
    }

    private boolean areParamsEquals(Properties theirParams) {
        int theirIdentity;
        int ourIdentity;
        boolean result = this.params == null ? theirParams == null : (theirParams == null ? this.params == null : ((ourIdentity = System.identityHashCode(this.params)) <= (theirIdentity = System.identityHashCode(theirParams)) ? this.params.equals(theirParams) : theirParams.equals(this.params)));
        return result;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.address, this.filterAddress, this.endpointName, this.connectorName, this.transformers, this.responseTransformers, this.params, this.uri, this.schemeMetaInfo, this.resourceInfo});
    }

    private abstract class DataExtractor {
        private DataExtractor() {
        }

        public abstract String extract(String var1);
    }
}

