/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.mule.api.context.notification.AbstractBlockingServerEvent;
import org.mule.api.transaction.Transaction;

public class TransactionNotification
extends AbstractBlockingServerEvent {
    private static final long serialVersionUID = -3245036187011582121L;
    private static String UNKNOWN_APPLICATION_NAME = "unknown";
    public static final int TRANSACTION_BEGAN = 1201;
    public static final int TRANSACTION_COMMITTED = 1202;
    public static final int TRANSACTION_ROLLEDBACK = 1203;
    private String applicationName;
    private String transactionStringId;

    public TransactionNotification(Transaction transaction, int action) {
        this(transaction, action, UNKNOWN_APPLICATION_NAME);
    }

    public TransactionNotification(Transaction transaction, int action, String applicationName) {
        super(transaction.getId(), action, transaction.getId());
        this.transactionStringId = transaction.getId();
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getTransactionStringId() {
        return this.transactionStringId;
    }

    @Override
    public String toString() {
        return this.EVENT_NAME + "{action=" + TransactionNotification.getActionName(this.action) + ", transactionStringId=" + this.transactionStringId + ", timestamp=" + this.timestamp + "}";
    }

    static {
        TransactionNotification.registerAction("begin", 1201);
        TransactionNotification.registerAction("commit", 1202);
        TransactionNotification.registerAction("rollback", 1203);
    }
}

