/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.Message;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;

public class MessagingException
extends MuleException {
    public static final String PAYLOAD_INFO_KEY = "Payload";
    public static final String PAYLOAD_TYPE_INFO_KEY = "Payload Type";
    private static final long serialVersionUID = 6941498759267936649L;
    protected transient MuleMessage muleMessage;
    protected final transient MuleEvent event;
    protected transient MuleEvent processedEvent;
    private boolean causeRollback;
    private boolean handled;
    private transient MessageProcessor failingMessageProcessor;

    @Deprecated
    public MessagingException(Message message, MuleMessage muleMessage) {
        this.muleMessage = muleMessage;
        this.event = null;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleEvent event) {
        this.event = event;
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleEvent event, MessageProcessor failingMessageProcessor) {
        this.event = event;
        this.extractMuleMessage(event);
        this.failingMessageProcessor = failingMessageProcessor;
        this.setMessage(this.generateMessage(message));
    }

    @Deprecated
    public MessagingException(Message message, MuleMessage muleMessage, Throwable cause) {
        super(cause);
        this.muleMessage = muleMessage;
        this.event = null;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleEvent event, Throwable cause) {
        super(cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(Message message, MuleEvent event, Throwable cause, MessageProcessor failingMessageProcessor) {
        super(cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.failingMessageProcessor = failingMessageProcessor;
        this.setMessage(this.generateMessage(message));
    }

    public MessagingException(MuleEvent event, Throwable cause) {
        super(cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.setMessage(this.generateMessage(this.getI18nMessage()));
    }

    public MessagingException(MuleEvent event, Throwable cause, MessageProcessor failingMessageProcessor) {
        super(cause);
        this.event = event;
        this.extractMuleMessage(event);
        this.failingMessageProcessor = failingMessageProcessor;
        this.setMessage(this.generateMessage(this.getI18nMessage()));
    }

    protected String generateMessage(Message message) {
        StringBuilder buf = new StringBuilder(80);
        if (message != null) {
            buf.append(message.getMessage()).append(".");
        }
        if (this.muleMessage != null) {
            if (DefaultMuleConfiguration.isVerboseExceptions()) {
                Object payload = this.muleMessage.getPayload();
                if (payload == null) {
                    payload = NullPayload.getInstance();
                }
                if (ClassUtils.isConsumable(this.muleMessage.getPayload().getClass())) {
                    this.addInfo(PAYLOAD_INFO_KEY, StringUtils.abbreviate((String)payload.toString(), (int)1000));
                } else {
                    this.addInfo(PAYLOAD_TYPE_INFO_KEY, this.muleMessage.getPayload().getClass().getName());
                    try {
                        this.addInfo(PAYLOAD_INFO_KEY, this.muleMessage.getPayloadAsString());
                    }
                    catch (Exception e) {
                        this.addInfo(PAYLOAD_INFO_KEY, String.format("%s while getting payload: %s", e.getClass().getName(), e.getMessage()));
                    }
                }
            }
        } else {
            buf.append("The current MuleMessage is null!");
            this.addInfo(PAYLOAD_INFO_KEY, NullPayload.getInstance().toString());
        }
        return buf.toString();
    }

    @Deprecated
    public MuleMessage getMuleMessage() {
        if (this.getEvent() != null) {
            return this.event.getMessage();
        }
        return this.muleMessage;
    }

    public MuleEvent getEvent() {
        return this.processedEvent != null && !VoidMuleEvent.getInstance().equals(this.processedEvent) ? this.processedEvent : this.event;
    }

    public void setProcessedEvent(MuleEvent processedEvent) {
        if (processedEvent != null && !VoidMuleEvent.getInstance().equals(processedEvent)) {
            this.processedEvent = processedEvent;
            this.extractMuleMessage(processedEvent);
        } else {
            this.processedEvent = null;
            this.muleMessage = null;
        }
    }

    public boolean causedBy(final Class e) {
        if (e == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy(this, new ExceptionHelper.ExceptionEvaluator<Object>(){

            @Override
            public Object evaluate(Throwable causeException) {
                if (e.isAssignableFrom(causeException.getClass())) {
                    return causeException;
                }
                return null;
            }
        }) != null;
    }

    public boolean causedExactlyBy(final Class e) {
        if (e == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy(this, new ExceptionHelper.ExceptionEvaluator<Object>(){

            @Override
            public Object evaluate(Throwable causeException) {
                if (causeException.getClass().equals(e)) {
                    return causeException;
                }
                return null;
            }
        }) != null;
    }

    public Exception getCauseException() {
        Throwable rootException = ExceptionHelper.getRootException(this);
        if (rootException == null) {
            rootException = this;
        }
        return (Exception)rootException;
    }

    public boolean causeMatches(final String regex) {
        if (regex == null) {
            throw new IllegalArgumentException("regex cannot be null");
        }
        return ExceptionHelper.traverseCauseHierarchy(this, new ExceptionHelper.ExceptionEvaluator<Object>(){

            @Override
            public Object evaluate(Throwable e) {
                WildcardFilter wildcardFilter = new WildcardFilter(regex);
                if (wildcardFilter.accept(e.getClass().getName())) {
                    return e;
                }
                try {
                    RegExFilter regExFilter = new RegExFilter(regex);
                    if (regExFilter.accept(e.getClass().getName())) {
                        return e;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }) != null;
    }

    public boolean causedRollback() {
        return this.causeRollback;
    }

    public void setCauseRollback(boolean causeRollback) {
        this.causeRollback = causeRollback;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    public boolean handled() {
        return this.handled;
    }

    public MessageProcessor getFailingMessageProcessor() {
        return this.failingMessageProcessor;
    }

    protected void extractMuleMessage(MuleEvent event) {
        this.muleMessage = event == null || event instanceof VoidMuleEvent ? null : event.getMessage();
    }

    private void writeObject(ObjectOutputStream out) throws Exception {
        out.defaultWriteObject();
        if (this.failingMessageProcessor instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.failingMessageProcessor);
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean failingMessageProcessorWasSerialized = in.readBoolean();
        if (failingMessageProcessorWasSerialized) {
            this.failingMessageProcessor = (MessageProcessor)in.readObject();
        }
    }
}

