/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import org.mule.util.queue.QueueStore;
import org.mule.util.queue.QueueTransactionContext;
import org.mule.util.queue.QueueTransactionContextFactory;

public class QueueTypeTransactionContextAdapter<T extends QueueTransactionContext>
implements QueueTransactionContext {
    private final QueueTransactionContextFactory<T> queueTransactionContextFactory;
    private T transactionContext;

    public QueueTypeTransactionContextAdapter(QueueTransactionContextFactory<T> queueTransactionContextFactory) {
        this.queueTransactionContextFactory = queueTransactionContextFactory;
    }

    @Override
    public boolean offer(QueueStore queue, Serializable item, long offerTimeout) throws InterruptedException {
        this.defineDelegate(queue);
        return this.transactionContext.offer(queue, item, offerTimeout);
    }

    @Override
    public void untake(QueueStore queue, Serializable item) throws InterruptedException {
        this.defineDelegate(queue);
        this.transactionContext.untake(queue, item);
    }

    @Override
    public void clear(QueueStore queue) throws InterruptedException {
        this.defineDelegate(queue);
        this.transactionContext.clear(queue);
    }

    @Override
    public Serializable poll(QueueStore queue, long pollTimeout) throws InterruptedException {
        this.defineDelegate(queue);
        return this.transactionContext.poll(queue, pollTimeout);
    }

    @Override
    public Serializable peek(QueueStore queue) throws InterruptedException {
        this.defineDelegate(queue);
        return this.transactionContext.peek(queue);
    }

    @Override
    public int size(QueueStore queue) {
        this.defineDelegate(queue);
        return this.transactionContext.size(queue);
    }

    public T getTransactionContext() {
        this.defineDelegate();
        return this.transactionContext;
    }

    private void defineDelegate() {
        if (this.transactionContext == null) {
            this.transactionContext = this.queueTransactionContextFactory.createPersistentTransactionContext();
        }
    }

    private void defineDelegate(QueueStore queue) {
        if (this.transactionContext == null) {
            this.transactionContext = queue.isPersistent() ? this.queueTransactionContextFactory.createPersistentTransactionContext() : this.queueTransactionContextFactory.createTransientTransactionContext();
        }
    }
}

