/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling.watermark.selector;

import java.io.Serializable;
import java.util.Iterator;
import org.mule.api.MuleEvent;
import org.mule.api.config.ConfigurationException;
import org.mule.api.store.ObjectStoreException;
import org.mule.config.i18n.CoreMessages;
import org.mule.streaming.ProvidesTotalHint;
import org.mule.transport.polling.watermark.Watermark;
import org.mule.transport.polling.watermark.WatermarkPollingInterceptor;
import org.mule.transport.polling.watermark.selector.WatermarkSelector;
import org.mule.transport.polling.watermark.selector.WatermarkSelectorWrapper;

public class SelectorWatermarkPollingInterceptor
extends WatermarkPollingInterceptor {
    private final WatermarkSelector selector;
    private final String selectorExpression;

    public SelectorWatermarkPollingInterceptor(Watermark watermark, WatermarkSelector selector, String selectorExpression) {
        super(watermark);
        this.selector = selector;
        this.selectorExpression = selectorExpression;
    }

    @Override
    public MuleEvent prepareRouting(MuleEvent sourceEvent, MuleEvent event) throws ConfigurationException {
        event = super.prepareRouting(sourceEvent, event);
        Object payload = event.getMessage().getPayload();
        WatermarkSelectorWrapper selector = new WatermarkSelectorWrapper(this.selector, this.selectorExpression, event);
        if (payload instanceof Iterable) {
            for (Object object : (Iterable)payload) {
                ((WatermarkSelector)selector).acceptValue(object);
            }
        } else if (payload instanceof Iterator) {
            event.getMessage().setPayload(new SelectorIteratorProxy((Iterator)payload, selector));
        } else {
            throw new ConfigurationException(CoreMessages.createStaticMessage(String.format("Poll executing with payload of class %s but selector can only handle Iterator and Iterable objects when watermark is to be updated via selectors", payload.getClass().getCanonicalName())));
        }
        return event;
    }

    @Override
    public void postProcessRouting(MuleEvent event) throws ObjectStoreException {
        this.watermark.updateWith(event, (Serializable)this.selector.getSelectedValue());
    }

    private static class SelectorIteratorProxy<T>
    implements Iterator<T>,
    ProvidesTotalHint {
        private final Iterator<T> delegate;
        private final WatermarkSelector selector;

        private SelectorIteratorProxy(Iterator<T> delegate, WatermarkSelector selector) {
            this.delegate = delegate;
            this.selector = selector;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            T next = this.delegate.next();
            this.selector.acceptValue(next);
            return next;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public int size() {
            return this.delegate instanceof ProvidesTotalHint ? ((ProvidesTotalHint)((Object)this.delegate)).size() : -1;
        }
    }
}

