/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transport.WorkTracker;

public class ConcurrentWorkTracker
implements WorkTracker {
    protected static final Log logger = LogFactory.getLog(ConcurrentWorkTracker.class);
    private final ReadWriteLock registryLock = new ReentrantReadWriteLock();
    private final List<Runnable> works = new LinkedList<Runnable>();

    @Override
    public List<Runnable> pendingWorks() {
        Lock lock = this.registryLock.readLock();
        try {
            lock.lock();
            List<Runnable> list = Collections.unmodifiableList(this.works);
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addWork(Runnable work) {
        Lock lock = this.registryLock.writeLock();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Tracking work: " + work));
            }
            lock.lock();
            this.works.add(work);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeWork(Runnable work) {
        Lock lock = this.registryLock.writeLock();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Untracking work: " + work));
            }
            lock.lock();
            this.works.remove(work);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void dispose() {
        Lock lock = this.registryLock.writeLock();
        try {
            lock.lock();
            this.works.clear();
        }
        finally {
            lock.unlock();
        }
    }
}

