/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.TransformerChain;
import org.mule.transformer.TransformerWeighting;
import org.mule.transformer.graph.GraphTransformerResolver;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.transformer.simple.ObjectToString;
import org.mule.transformer.types.SimpleDataType;

public class TypeBasedTransformerResolver
implements TransformerResolver,
MuleContextAware,
Disposable,
Initialisable {
    protected final transient Log logger = LogFactory.getLog(TypeBasedTransformerResolver.class);
    private ObjectToString objectToString;
    private ObjectToByteArray objectToByteArray;
    private MuleContext muleContext;
    protected Map<String, Transformer> exactTransformerCache = new ConcurrentHashMap<String, Transformer>(8);
    protected TransformerResolver graphTransformerResolver = new GraphTransformerResolver();

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.objectToString = new ObjectToString();
            this.objectToByteArray = new ObjectToByteArray();
            LifecycleUtils.initialiseIfNeeded(this.objectToString, this.muleContext);
            LifecycleUtils.initialiseIfNeeded(this.objectToByteArray, this.muleContext);
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public Transformer resolve(DataType source, DataType result) throws ResolverException {
        Transformer compositeTransformer;
        Transformer transformer = this.exactTransformerCache.get(source.toString() + result.toString());
        if (transformer != null) {
            return transformer;
        }
        List<Transformer> trans = this.muleContext.getRegistry().lookupTransformers(source, result);
        if (this.muleContext != null && this.muleContext.getConfiguration().useExtendedTransformations() && (compositeTransformer = this.graphTransformerResolver.resolve(source, result)) != null) {
            trans = new LinkedList<Transformer>(trans);
            trans.add(compositeTransformer);
        }
        if ((transformer = this.getNearestTransformerMatch(trans, source.getType(), result.getType())) == null) {
            AbstractTransformer secondPass;
            if (result.getType().equals(String.class)) {
                secondPass = this.objectToString;
            } else if (result.getType().equals(byte[].class)) {
                secondPass = this.objectToByteArray;
            } else {
                return null;
            }
            trans = this.muleContext.getRegistry().lookupTransformers(source, new SimpleDataType(Object.class));
            transformer = this.getNearestTransformerMatch(trans, source.getType(), result.getType());
            if (transformer != null) {
                transformer = new TransformerChain(transformer, secondPass);
                try {
                    this.muleContext.getRegistry().registerTransformer(transformer);
                }
                catch (MuleException e) {
                    throw new ResolverException(e.getI18nMessage(), (Throwable)e);
                }
            }
        }
        if (transformer != null) {
            this.exactTransformerCache.put(source.toString() + result.toString(), transformer);
        }
        return transformer;
    }

    protected Transformer getNearestTransformerMatch(List<Transformer> trans, Class input, Class output) throws ResolverException {
        if (trans.size() > 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Comparing transformers for best match: source = " + input + " target = " + output + " Possible transformers = " + trans));
            }
            List<TransformerWeighting> weightings = this.calculateTransformerWeightings(trans, input, output);
            TransformerWeighting maxWeighting = weightings.get(weightings.size() - 1);
            for (int index = weightings.size() - 2; index >= 0 && maxWeighting.compareTo(weightings.get(index)) == 0; --index) {
                TransformerWeighting current = weightings.get(index);
                if (maxWeighting.getTransformer().getClass().equals(current.getTransformer().getClass())) continue;
                List<Transformer> transformers = Arrays.asList(current.getTransformer(), maxWeighting.getTransformer());
                throw new ResolverException(CoreMessages.transformHasMultipleMatches(input, output, transformers));
            }
            return maxWeighting.getTransformer();
        }
        if (trans.size() == 0) {
            return null;
        }
        return trans.get(0);
    }

    private List<TransformerWeighting> calculateTransformerWeightings(List<Transformer> transformers, Class input, Class output) {
        ArrayList<TransformerWeighting> weightings = new ArrayList<TransformerWeighting>(transformers.size());
        for (Transformer transformer : transformers) {
            TransformerWeighting transformerWeighting = new TransformerWeighting(input, output, transformer);
            weightings.add(transformerWeighting);
        }
        Collections.sort(weightings);
        return weightings;
    }

    @Override
    public void dispose() {
        this.exactTransformerCache.clear();
    }

    @Override
    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
        if (transformer instanceof Converter) {
            this.graphTransformerResolver.transformerChange(transformer, registryAction);
            this.exactTransformerCache.clear();
        }
    }
}

