/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.processor.DynamicPipeline;
import org.mule.api.processor.DynamicPipelineBuilder;
import org.mule.api.processor.DynamicPipelineException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.processor.NamedStageNameSource;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.processor.SequentialStageNameSource;
import org.mule.api.processor.StageNameSource;
import org.mule.api.processor.StageNameSourceProvider;
import org.mule.api.transport.ExceptionHandlingReplyToHandlerDecorator;
import org.mule.api.transport.NonBlockingReplyToHandler;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.AbstractPipeline;
import org.mule.construct.DynamicPipelineMessageProcessor;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.construct.processor.FlowConstructStatisticsMessageProcessor;
import org.mule.execution.ErrorHandlingExecutionTemplate;
import org.mule.interceptor.ProcessingTimeInterceptor;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.processor.strategy.NonBlockingProcessingStrategy;
import org.mule.processor.strategy.QueuedAsynchronousProcessingStrategy;
import org.mule.routing.requestreply.AsyncReplyToPropertyRequestReplyReplier;
import org.mule.work.SerialWorkManager;

public class Flow
extends AbstractPipeline
implements MessageProcessor,
StageNameSourceProvider,
DynamicPipeline {
    private int stageCount = 0;
    private final StageNameSource sequentialStageNameSource;
    private DynamicPipelineMessageProcessor dynamicPipelineMessageProcessor;
    private WorkManager workManager;

    public Flow(String name, MuleContext muleContext) {
        super(name, muleContext);
        this.sequentialStageNameSource = new SequentialStageNameSource(name);
        this.initialiseProcessingStrategy();
    }

    @Override
    protected void doInitialise() throws MuleException {
        super.doInitialise();
        this.workManager = this.processingStrategy instanceof NonBlockingProcessingStrategy ? ((NonBlockingProcessingStrategy)this.processingStrategy).createWorkManager(this) : new SerialWorkManager();
    }

    @Override
    protected void doStart() throws MuleException {
        if (this.workManager != null) {
            this.workManager.start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws MuleException {
        super.doStop();
        if (this.workManager != null) {
            this.workManager.dispose();
        }
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        final MuleEvent newEvent = this.createMuleEventForCurrentFlow(event, event.getReplyToDestination(), event.getReplyToHandler());
        try {
            ErrorHandlingExecutionTemplate executionTemplate = ErrorHandlingExecutionTemplate.createErrorHandlingExecutionTemplate(this.muleContext, this.getExceptionListener());
            MuleEvent result = executionTemplate.execute(new ExecutionCallback<MuleEvent>(){

                @Override
                public MuleEvent process() throws Exception {
                    return Flow.this.pipeline.process(newEvent);
                }
            });
            return this.createReturnEventForParentFlowConstruct(result, event);
        }
        catch (MessagingException e) {
            e.setProcessedEvent(this.createReturnEventForParentFlowConstruct(e.getEvent(), event));
            throw e;
        }
        catch (Exception e) {
            this.resetRequestContextEvent(event);
            throw new DefaultMuleException(CoreMessages.createStaticMessage("Flow execution exception"), (Throwable)e);
        }
    }

    private MuleEvent createMuleEventForCurrentFlow(MuleEvent event, Object replyToDestination, ReplyToHandler replyToHandler) {
        replyToHandler = replyToHandler != null && replyToHandler instanceof NonBlockingReplyToHandler ? this.createNonBlockingReplyToHandler(event, replyToHandler) : null;
        event = new DefaultMuleEvent(event, this, replyToHandler, replyToDestination, event.isSynchronous() || this.isSynchronous());
        this.resetRequestContextEvent(event);
        return event;
    }

    private ReplyToHandler createNonBlockingReplyToHandler(final MuleEvent event, final ReplyToHandler replyToHandler) {
        return new ExceptionHandlingReplyToHandlerDecorator(new NonBlockingReplyToHandler(){

            @Override
            public void processReplyTo(MuleEvent result, MuleMessage returnMessage, Object replyTo) throws MuleException {
                replyToHandler.processReplyTo(Flow.this.createReturnEventForParentFlowConstruct(result, event), null, null);
            }

            @Override
            public void processExceptionReplyTo(MessagingException exception, Object replyTo) {
                exception.setProcessedEvent(Flow.this.createReturnEventForParentFlowConstruct(exception.getEvent(), event));
                replyToHandler.processExceptionReplyTo(exception, null);
            }
        }, this.getExceptionListener());
    }

    private MuleEvent createReturnEventForParentFlowConstruct(MuleEvent result, MuleEvent original) {
        if (result != null && !(result instanceof VoidMuleEvent)) {
            result = new DefaultMuleEvent(result, original.getFlowConstruct(), original.getReplyToHandler(), original.getReplyToDestination(), original.isSynchronous());
        }
        this.resetRequestContextEvent(result);
        return result;
    }

    private void resetRequestContextEvent(MuleEvent event) {
        OptimizedRequestContext.unsafeSetEvent(event);
    }

    @Override
    protected void configurePreProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        super.configurePreProcessors(builder);
        builder.chain(new AbstractPipeline.ProcessIfPipelineStartedMessageProcessor(this));
        builder.chain(new ProcessingTimeInterceptor());
        builder.chain(new FlowConstructStatisticsMessageProcessor());
        this.dynamicPipelineMessageProcessor = new DynamicPipelineMessageProcessor(this);
        builder.chain(this.dynamicPipelineMessageProcessor);
    }

    @Override
    protected void configurePostProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        builder.chain(new AsyncReplyToPropertyRequestReplyReplier());
        super.configurePostProcessors(builder);
    }

    @Override
    protected ProcessingStrategy createDefaultProcessingStrategy() {
        return new DefaultFlowProcessingStrategy();
    }

    @Deprecated
    public void setEndpoint(InboundEndpoint endpoint) {
        this.messageSource = endpoint;
    }

    @Override
    public String getConstructType() {
        return "Flow";
    }

    @Override
    protected void configureStatistics() {
        this.statistics = this.processingStrategy instanceof AsynchronousProcessingStrategy && ((AsynchronousProcessingStrategy)this.processingStrategy).getMaxThreads() != null ? new FlowConstructStatistics(this.getConstructType(), this.name, ((AsynchronousProcessingStrategy)this.processingStrategy).getMaxThreads()) : new FlowConstructStatistics(this.getConstructType(), this.name);
        if (this.processingStrategy instanceof QueuedAsynchronousProcessingStrategy) {
            ((QueuedAsynchronousProcessingStrategy)this.processingStrategy).setQueueStatistics(this.statistics);
        }
        this.statistics.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.statistics);
    }

    @Override
    protected void configureMessageProcessors(MessageProcessorChainBuilder builder) throws MuleException {
        this.getProcessingStrategy().configureProcessors(this.getMessageProcessors(), new StageNameSource(){

            @Override
            public String getName() {
                return String.format("%s.stage%s", Flow.this.getName(), ++Flow.this.stageCount);
            }
        }, builder, this.muleContext);
    }

    @Override
    public StageNameSource getAsyncStageNameSource() {
        return this.sequentialStageNameSource;
    }

    @Override
    public StageNameSource getAsyncStageNameSource(String asyncName) {
        return new NamedStageNameSource(this.name, asyncName);
    }

    @Override
    public DynamicPipelineBuilder dynamicPipeline(String id) throws DynamicPipelineException {
        return this.dynamicPipelineMessageProcessor.dynamicPipeline(id);
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }
}

