/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CredentialsMaskUtil {
    public static final Pattern BARE_URL_PATTERN = Pattern.compile("[a-z]*://([^@]*)@");
    public static final Pattern URL_PATTERN = Pattern.compile("url=\"[a-z]*://([^@]*)@");
    public static final Pattern ADDRESS_PATTERN = Pattern.compile("address=\"[a-z]*://([^@]*)@");
    public static final Pattern PASSWORD_PATTERN = Pattern.compile("password=\"([^\"]*)\"");
    public static final Pattern PASSWORD_PATTERN_NO_QUOTES = Pattern.compile("password=([^\\s;]+)");
    public static final Pattern USER_PATTERN_NO_QUOTES = Pattern.compile("user=([^\\s;]+)");
    public static final String PASSWORD_MASK = "<<credentials>>";
    public static final String USER_MASK = "<<user>>";
    public static final String PASSWORD_ATTRIBUTE_MASK = "password=\"%s\"";
    private static final String USER_URL_PREFIX = "user=";
    private static final String PASSWORD_URL_PREFIX = "password=";

    public static String maskPasswords(String input) {
        input = CredentialsMaskUtil.maskUrlPassword(input, URL_PATTERN);
        Matcher matcher = PASSWORD_PATTERN.matcher(input = CredentialsMaskUtil.maskUrlPassword(input, ADDRESS_PATTERN));
        if (matcher.find() && matcher.groupCount() > 0) {
            input = input.replaceAll(CredentialsMaskUtil.maskPasswordAttribute(matcher.group(1)), CredentialsMaskUtil.maskPasswordAttribute(PASSWORD_MASK));
        }
        input = CredentialsMaskUtil.maskUrlPassword(input, PASSWORD_PATTERN);
        return input;
    }

    public static String maskUrlPassword(String input, Pattern pattern) {
        return CredentialsMaskUtil.maskUrlPattern(input, pattern, PASSWORD_MASK);
    }

    public static String maskUrlUserAndPassword(String input, Pattern passwordPattern, Pattern userPattern) {
        String inputMasked = CredentialsMaskUtil.maskUrlPattern(input, passwordPattern, PASSWORD_MASK, PASSWORD_URL_PREFIX);
        return CredentialsMaskUtil.maskUrlPattern(inputMasked, userPattern, USER_MASK, USER_URL_PREFIX);
    }

    public static String maskPasswordAttribute(String password) {
        return String.format(PASSWORD_ATTRIBUTE_MASK, password);
    }

    private static String maskUrlPattern(String input, Pattern pattern, String mask) {
        return CredentialsMaskUtil.maskUrlPattern(input, pattern, mask, "");
    }

    private static String maskUrlPattern(String input, Pattern pattern, String mask, String prefix) {
        Matcher matcher = pattern.matcher(input);
        if (matcher.find() && matcher.groupCount() > 0) {
            input = input.replaceAll(prefix + matcher.group(1), prefix + mask);
        }
        return input;
    }
}

