/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.schedule;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.schedule.Scheduler;
import org.mule.api.schedule.SchedulerCreationException;
import org.mule.api.schedule.SchedulerFactoryPostProcessor;
import org.mule.config.i18n.CoreMessages;

public abstract class SchedulerFactory<T extends Runnable>
implements MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleContext context;

    public final Scheduler create(String name, T job) throws SchedulerCreationException {
        Scheduler scheduler = this.doCreate(name, job);
        this.checkNull(scheduler);
        Scheduler postProcessedScheduler = this.postProcess(job, scheduler);
        this.checkNull(postProcessedScheduler);
        return postProcessedScheduler;
    }

    protected abstract Scheduler doCreate(String var1, T var2);

    private Scheduler postProcess(T job, Scheduler scheduler) {
        if (this.context == null) {
            return scheduler;
        }
        Map<String, SchedulerFactoryPostProcessor> postProcessors = this.context.getRegistry().lookupByType(SchedulerFactoryPostProcessor.class);
        for (SchedulerFactoryPostProcessor postProcessor : postProcessors.values()) {
            scheduler = postProcessor.process(job, scheduler);
            this.checkNull(scheduler);
        }
        this.registerScheduler(scheduler);
        return scheduler;
    }

    private void registerScheduler(Scheduler scheduler) {
        try {
            this.context.getRegistry().registerScheduler(scheduler);
        }
        catch (MuleException e) {
            this.logger.error((Object)CoreMessages.couldNotRegisterNewScheduler(scheduler.getName()), (Throwable)e);
        }
    }

    private void checkNull(Scheduler postProcessedScheduler) {
        if (postProcessedScheduler == null) {
            throw new SchedulerCreationException(CoreMessages.objectIsNull("scheduler").toString());
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }
}

