/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.api.registry.RegistrationException;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.store.PartitionableObjectStore;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.util.store.MuleObjectStoreManager;
import org.mule.util.store.ObjectStorePartition;
import org.mule.util.store.PartitionedInMemoryObjectStore;
import org.mule.util.store.PartitionedObjectStoreWrapper;
import org.mule.util.store.PartitionedPersistentObjectStore;
import org.mule.util.store.QueuePersistenceObjectStore;
import org.mule.util.store.SimpleMemoryObjectStore;

public class ManagedStoresTestCase
extends AbstractMuleContextTestCase {
    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        MuleObjectStoreManager manager = (MuleObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        manager.clearStoreCache();
    }

    @Test
    public void testInMemoryStore() throws ObjectStoreException, InterruptedException, RegistrationException {
        muleContext.getRegistry().registerObject("_defaultInMemoryObjectStore", (Object)new SimpleMemoryObjectStore());
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("inMemoryPart1", false);
        Assert.assertTrue((boolean)(store instanceof PartitionedObjectStoreWrapper));
        ListableObjectStore baseStore = ((PartitionedObjectStoreWrapper)store).getBaseStore();
        Assert.assertTrue((boolean)(baseStore instanceof SimpleMemoryObjectStore));
        Assert.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultInMemoryObjectStore"));
        this.testObjectStore((ListableObjectStore<String>)store);
        this.testObjectStoreExpiry((ObjectStore<String>)manager.getObjectStore("inMemoryExpPart1", false, -1, 500, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore<String>)((ListableObjectStore)manager.getObjectStore("inMemoryMaxPart1", false, 10, 10000, 200)));
    }

    @Test
    public void testClearPartition() throws ObjectStoreException, InterruptedException, RegistrationException {
        muleContext.getRegistry().registerObject("_defaultInMemoryObjectStore", (Object)new SimpleMemoryObjectStore());
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ObjectStore partition1 = manager.getObjectStore("inMemoryPart1", false);
        ObjectStore partition2 = manager.getObjectStore("inMemoryPart2", false);
        partition1.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        partition2.store((Serializable)((Object)"key2"), (Serializable)((Object)"value2"));
        Assert.assertEquals((Object)"value1", (Object)partition1.retrieve((Serializable)((Object)"key1")));
        Assert.assertEquals((Object)"value2", (Object)partition2.retrieve((Serializable)((Object)"key2")));
        partition1.clear();
        Assert.assertEquals((Object)"value2", (Object)partition2.retrieve((Serializable)((Object)"key2")));
    }

    @Test
    public void testPersistentStore() throws ObjectStoreException, InterruptedException, RegistrationException {
        QueuePersistenceObjectStore queueStore = new QueuePersistenceObjectStore(muleContext);
        queueStore.open();
        muleContext.getRegistry().registerObject("_defaultPersistentObjectStore", (Object)queueStore);
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("persistencePart1", true);
        Assert.assertTrue((boolean)(store instanceof PartitionedObjectStoreWrapper));
        ListableObjectStore baseStore = ((PartitionedObjectStoreWrapper)store).getBaseStore();
        Assert.assertTrue((boolean)(baseStore instanceof QueuePersistenceObjectStore));
        Assert.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultPersistentObjectStore"));
        this.testObjectStore((ListableObjectStore<String>)store);
        this.testObjectStoreExpiry((ObjectStore<String>)manager.getObjectStore("persistenceExpPart1", true, -1, 500, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore<String>)((ListableObjectStore)manager.getObjectStore("persistenceMaxPart1", true, 10, 10000, 200)));
    }

    @Test
    public void testPartitionableInMemoryStore() throws ObjectStoreException, RegistrationException, InterruptedException {
        muleContext.getRegistry().registerObject("_defaultInMemoryObjectStore", (Object)new PartitionedInMemoryObjectStore());
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("inMemoryPart2", false);
        Assert.assertTrue((boolean)(store instanceof ObjectStorePartition));
        PartitionableObjectStore baseStore = ((ObjectStorePartition)store).getBaseStore();
        Assert.assertTrue((boolean)(baseStore instanceof PartitionedInMemoryObjectStore));
        Assert.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultInMemoryObjectStore"));
        this.testObjectStore((ListableObjectStore<String>)store);
        this.testObjectStoreExpiry((ObjectStore<String>)manager.getObjectStore("inMemoryExpPart2", false, -1, 500, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore<String>)((ListableObjectStore)manager.getObjectStore("inMemoryMaxPart2", false, 10, 10000, 200)));
    }

    @Ignore(value="MULE-6926")
    @Test
    public void testPartitionablePersistenceStore() throws ObjectStoreException, RegistrationException, InterruptedException {
        PartitionedPersistentObjectStore partitionedStore = new PartitionedPersistentObjectStore(muleContext);
        partitionedStore.open();
        muleContext.getRegistry().registerObject("_defaultPersistentObjectStore", (Object)partitionedStore);
        ObjectStoreManager manager = (ObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        ListableObjectStore store = (ListableObjectStore)manager.getObjectStore("persistencePart2", true);
        Assert.assertTrue((boolean)(store instanceof ObjectStorePartition));
        PartitionableObjectStore baseStore = ((ObjectStorePartition)store).getBaseStore();
        Assert.assertTrue((boolean)(baseStore instanceof PartitionedPersistentObjectStore));
        Assert.assertSame((Object)baseStore, (Object)muleContext.getRegistry().lookupObject("_defaultPersistentObjectStore"));
        this.testObjectStore((ListableObjectStore<String>)store);
        this.testObjectStoreExpiry((ObjectStore<String>)manager.getObjectStore("persistenceExpPart2", true, -1, 1000, 200));
        this.testObjectStoreMaxEntries((ListableObjectStore<String>)((ListableObjectStore)manager.getObjectStore("persistenceMaxPart2", true, 10, 10000, 200)));
    }

    private void testObjectStore(ListableObjectStore<String> store) throws ObjectStoreException {
        Throwable e = null;
        store.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        Assert.assertEquals((Object)"value1", (Object)store.retrieve((Serializable)((Object)"key1")));
        Assert.assertTrue((boolean)store.contains((Serializable)((Object)"key1")));
        store.clear();
        Assert.assertFalse((boolean)store.contains((Serializable)((Object)"key1")));
        store.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        try {
            store.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        }
        catch (ObjectAlreadyExistsException e1) {
            e = e1;
        }
        Assert.assertNotNull((Object)e);
        e = null;
        Assert.assertEquals((long)1L, (long)store.allKeys().size());
        Assert.assertEquals((Object)"key1", store.allKeys().get(0));
        Assert.assertEquals((Object)"value1", (Object)store.remove((Serializable)((Object)"key1")));
        Assert.assertFalse((boolean)store.contains((Serializable)((Object)"key1")));
        try {
            store.retrieve((Serializable)((Object)"key1"));
        }
        catch (ObjectDoesNotExistException e1) {
            e = e1;
        }
        Assert.assertNotNull((Object)e);
        e = null;
        try {
            store.remove((Serializable)((Object)"key1"));
        }
        catch (ObjectDoesNotExistException e1) {
            e = e1;
        }
        Assert.assertNotNull((Object)e);
        e = null;
    }

    private void testObjectStoreExpiry(final ObjectStore<String> objectStore) throws ObjectStoreException, InterruptedException {
        objectStore.store((Serializable)((Object)"key1"), (Serializable)((Object)"value1"));
        Assert.assertEquals((Object)"value1", (Object)objectStore.retrieve((Serializable)((Object)"key1")));
        new PollingProber(2000L, 50L).check(new JUnitProbe(){

            @Override
            public boolean test() {
                try {
                    Assert.assertFalse((String)"Object with key1 still exists.", (boolean)objectStore.contains((Serializable)((Object)"key1")));
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                return true;
            }
        });
    }

    private void testObjectStoreMaxEntries(final ListableObjectStore<String> objectStore) throws ObjectStoreException, InterruptedException {
        this.storeObjects(objectStore, 0, 90);
        this.ensureMillisecondChanged();
        this.storeObjects(objectStore, 90, 100);
        new PollingProber(2000L, 50L).check(new JUnitProbe(){

            @Override
            public boolean test() {
                try {
                    Assert.assertEquals((long)10L, (long)objectStore.allKeys().size());
                    for (int i = 90; i < 100; ++i) {
                        Assert.assertTrue((String)("Checking that key" + i + " exists"), (boolean)objectStore.contains((Serializable)((Object)("key" + i))));
                    }
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                return true;
            }
        });
    }

    private void ensureMillisecondChanged() throws InterruptedException {
        Thread.sleep(2L);
    }

    private void storeObjects(ListableObjectStore<String> objectStore, int start, int stop) throws ObjectStoreException {
        for (int i = start; i < stop; ++i) {
            objectStore.store((Serializable)((Object)("key" + i)), (Serializable)((Object)("value" + i)));
            Assert.assertEquals((Object)("value" + i), (Object)objectStore.retrieve((Serializable)((Object)("key" + i))));
        }
    }
}

