/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.util.monitor.Expirable;
import org.mule.util.monitor.ExpiryMonitor;

public class ExpiryMonitorTestCase
extends AbstractMuleTestCase {
    private static final int EXPIRE_TIME = 300;
    private static final int EXPIRE_INTERVAL = 100;
    private static final int EXPIRE_TIMEOUT = 500;
    private static final long DELTA_TIME = 10L;
    private boolean expired = false;
    private long expiredTime = -1L;
    private ExpiryMonitor monitor;

    @Before
    public void doSetUp() throws Exception {
        this.expired = false;
        this.monitor = new ExpiryMonitor("test", 100, null, false);
    }

    @After
    public void after() {
        this.monitor.dispose();
    }

    @Test
    public void testExpiry() throws InterruptedException {
        final Expirable e = new Expirable(){

            public void expired() {
                ExpiryMonitorTestCase.this.expire();
            }
        };
        this.monitor.addExpirable(300L, TimeUnit.MILLISECONDS, e);
        new PollingProber(500L, 50L).check(new JUnitProbe(){

            @Override
            public boolean test() {
                Assert.assertThat((Object)ExpiryMonitorTestCase.this.expired, (Matcher)Is.is((Object)true));
                Assert.assertThat((Object)ExpiryMonitorTestCase.this.monitor.isRegistered(e), (Matcher)Is.is((Object)false));
                return true;
            }
        });
    }

    @Test
    public void testNotExpiry() throws InterruptedException {
        final Expirable e = new Expirable(){

            public void expired() {
                ExpiryMonitorTestCase.this.expire();
            }
        };
        long startTime = System.currentTimeMillis();
        this.monitor.addExpirable(300L, TimeUnit.MILLISECONDS, e);
        this.monitor.run();
        Assert.assertThat((Object)this.expired, (Matcher)Is.is((Object)false));
        new PollingProber(500L, 50L).check(new JUnitProbe(){

            @Override
            public boolean test() {
                Assert.assertThat((Object)ExpiryMonitorTestCase.this.expired, (Matcher)Is.is((Object)true));
                Assert.assertThat((Object)ExpiryMonitorTestCase.this.monitor.isRegistered(e), (Matcher)Is.is((Object)false));
                return true;
            }
        });
        Assert.assertThat((Object)(this.expiredTime - startTime), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(290L)));
    }

    @Test
    public void testExpiryWithReset() throws InterruptedException {
        final Expirable e = new Expirable(){

            public void expired() {
                ExpiryMonitorTestCase.this.expire();
            }
        };
        this.monitor.addExpirable(300L, TimeUnit.MILLISECONDS, e);
        this.monitor.run();
        Assert.assertThat((Object)this.expired, (Matcher)Is.is((Object)false));
        long startTime = System.currentTimeMillis();
        this.monitor.resetExpirable(e);
        this.monitor.run();
        Assert.assertTrue((!this.expired ? 1 : 0) != 0);
        new PollingProber(600L, 50L).check(new JUnitProbe(){

            @Override
            public boolean test() {
                Assert.assertThat((Object)ExpiryMonitorTestCase.this.expired, (Matcher)Is.is((Object)true));
                Assert.assertThat((Object)ExpiryMonitorTestCase.this.monitor.isRegistered(e), (Matcher)Is.is((Object)false));
                return true;
            }
        });
        Assert.assertThat((Object)(this.expiredTime - startTime), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(290L)));
    }

    @Test
    public void testNotExpiryWithRemove() throws InterruptedException {
        Expirable e = new Expirable(){

            public void expired() {
                ExpiryMonitorTestCase.this.expire();
            }
        };
        this.monitor.addExpirable(300L, TimeUnit.MILLISECONDS, e);
        this.monitor.run();
        Assert.assertThat((Object)this.expired, (Matcher)Is.is((Object)false));
        this.monitor.removeExpirable(e);
        Thread.sleep(500L);
        Assert.assertThat((Object)this.expired, (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.monitor.isRegistered(e), (Matcher)Is.is((Object)false));
    }

    private void expire() {
        this.expiredTime = System.currentTimeMillis();
        this.expired = true;
    }
}

