/*
 * Decompiled with CFR 0.152.
 */
package org.mule.streaming;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.streaming.QueueProducer;
import org.mule.tck.size.SmallTest;
import org.mule.util.queue.Queue;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class QueueProducerTestCase {
    @Mock
    private Queue queue;
    private Set<String> values;
    private Iterator<String> valuesIterator;
    private QueueProducer<Serializable> producer;

    @Before
    public void setUp() throws Exception {
        this.values = new HashSet<String>();
        this.values.add("banana");
        this.values.add("chocolate");
        this.values.add("coke");
        this.valuesIterator = this.values.iterator();
        Mockito.when((Object)this.queue.poll(Mockito.anyLong())).thenAnswer((Answer)new Answer<Serializable>(){

            public Serializable answer(InvocationOnMock invocation) throws Throwable {
                return QueueProducerTestCase.this.valuesIterator.hasNext() ? (String)QueueProducerTestCase.this.valuesIterator.next() : null;
            }
        });
        Mockito.when((Object)this.queue.size()).thenReturn((Object)this.values.size());
        this.producer = new QueueProducer(this.queue);
    }

    @Test
    public void happyPath() throws Exception {
        HashSet<Serializable> returnedValues = new HashSet<Serializable>();
        Serializable page = (Serializable)this.producer.produce();
        while (page != null) {
            returnedValues.add(page);
            page = (Serializable)this.producer.produce();
        }
        Assert.assertEquals((int)returnedValues.size(), (int)this.values.size());
        for (String value : this.values) {
            Assert.assertTrue((boolean)returnedValues.contains(value));
        }
        Assert.assertNull((Object)this.producer.produce());
    }

    @Test
    public void size() throws Exception {
        Assert.assertEquals((int)this.values.size(), (int)this.producer.size());
    }

    @Test
    public void earlyClose() throws Exception {
        this.producer.produce();
        this.producer.close();
        Assert.assertNull((Object)this.producer.produce());
    }
}

