/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.routing.filters.WildcardFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class WildcardFilterTestCase
extends AbstractMuleTestCase {
    private WildcardFilter filter = new WildcardFilter();

    @Test
    public void testWildcardFilterNoPattern() {
        Assert.assertFalse((boolean)this.filter.accept((Object)"No tengo dinero"));
        this.filter.setPattern("* brown fox");
        Assert.assertTrue((boolean)this.filter.accept((Object)"The quick brown fox"));
        this.filter.setPattern(null);
        Assert.assertFalse((boolean)this.filter.accept((Object)"oh-oh"));
    }

    @Test
    public void testWildcardFilterPostfix() {
        WildcardFilter filter = new WildcardFilter("The quick *");
        Assert.assertNotNull((Object)filter.getPattern());
        Assert.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)filter.accept((Object)"The quick *"));
        Assert.assertTrue((!filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        Assert.assertTrue((!filter.accept((Object)"he quick brown fox") ? 1 : 0) != 0);
    }

    @Test
    public void testWildcardFilterPrefix() {
        this.filter.setPattern("* brown fox");
        Assert.assertTrue((boolean)this.filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)this.filter.accept((Object)"* brown fox"));
        Assert.assertTrue((!this.filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        Assert.assertTrue((!this.filter.accept((Object)"The quick brown fo") ? 1 : 0) != 0);
    }

    @Test
    public void testWildcardFilterExactMatch() {
        this.filter.setPattern("fox");
        Assert.assertTrue((boolean)this.filter.accept((Object)"fox"));
        this.filter.setPattern("");
        Assert.assertTrue((boolean)this.filter.accept((Object)""));
    }

    @Test
    public void testWildcardFilterPrePost() {
        this.filter.setPattern("* brown *");
        Assert.assertTrue((boolean)this.filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)this.filter.accept((Object)"* brown fox"));
        Assert.assertTrue((!this.filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.filter.accept((Object)"The quick brown fo"));
        this.filter.setPattern("**");
        Assert.assertTrue((boolean)this.filter.accept((Object)"The quick brown fox"));
        this.filter.setPattern("*w*");
        Assert.assertTrue((boolean)this.filter.accept((Object)"The quick brown fox"));
        this.filter.setPattern("*");
        Assert.assertTrue((boolean)this.filter.accept((Object)"The quick brown fox"));
        this.filter.setPattern("*.*");
        Assert.assertTrue((boolean)this.filter.accept((Object)"test.xml"));
        this.filter.setPattern("*.txt");
        Assert.assertTrue((boolean)this.filter.accept((Object)"test.txt"));
    }

    @Test
    public void testWildcardFilterMultiplePatterns() {
        this.filter.setPattern("* brown*, The*");
        Assert.assertTrue((boolean)this.filter.accept((Object)"The quick brown fox"));
        Assert.assertTrue((boolean)this.filter.accept((Object)" brown fox"));
        Assert.assertTrue((boolean)this.filter.accept((Object)"The quickbrown fox"));
        this.filter.setPattern("* if, The*");
        Assert.assertTrue((!this.filter.accept((Object)"What The!") ? 1 : 0) != 0);
        Assert.assertTrue((!this.filter.accept((Object)"simplify") ? 1 : 0) != 0);
    }

    @Test
    public void testWildcardFilterCasesensitive() {
        this.filter.setPattern("* brown fox");
        Assert.assertFalse((boolean)this.filter.accept((Object)"The quick Brown fox"));
        Assert.assertTrue((boolean)this.filter.accept((Object)"* brown fox"));
        this.filter.setCaseSensitive(false);
        Assert.assertTrue((boolean)this.filter.accept((Object)"The quick Brown fox"));
    }

    @Test
    public void testWildcardMidPattern() {
        this.filter.setPattern("The quick * fox");
        Assert.assertThat((Object)this.filter.accept((Object)"The quick fox"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.filter.accept((Object)"The quick  black horse"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.filter.accept((Object)"The brown fox"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.filter.accept((Object)"The slow fox"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testTwoWildcardsMidPattern() {
        this.filter.setPattern("*the quick * fox");
        Assert.assertThat((Object)this.filter.accept((Object)"this is the quick horse"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.filter.accept((Object)"the quick * fox"), (Matcher)Matchers.is((Object)false));
        this.filter.setPattern("the * brown fox*");
        Assert.assertThat((Object)this.filter.accept((Object)"my brown fox"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.filter.accept((Object)"the brown fox here"), (Matcher)Matchers.is((Object)false));
        this.filter.setPattern("the * brown * run");
        Assert.assertThat((Object)this.filter.accept((Object)"the quick brown fox run"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.filter.accept((Object)"the brown goat"), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testClassAndSubclass() {
        this.filter.setPattern("java.lang.Throwable+");
        Assert.assertTrue((boolean)this.filter.accept((Object)new Exception()));
        Assert.assertTrue((boolean)this.filter.accept((Object)new Throwable()));
        Assert.assertFalse((boolean)this.filter.accept(new Object()));
        this.filter.setPattern("java.lang.Throwable");
        Assert.assertFalse((boolean)this.filter.accept((Object)new Exception()));
        Assert.assertTrue((boolean)this.filter.accept((Object)new Throwable()));
        Assert.assertFalse((boolean)this.filter.accept(new Object()));
    }

    @Test
    public void testClassAndSubclassUsingString() {
        this.filter.setPattern("java.lang.Throwable+");
        Assert.assertTrue((boolean)this.filter.accept((Object)new Exception().getClass().getName()));
        Assert.assertTrue((boolean)this.filter.accept((Object)new Throwable().getClass().getName()));
        Assert.assertFalse((boolean)this.filter.accept((Object)new Object().getClass().getName()));
        this.filter.setPattern("java.lang.Throwable");
        Assert.assertFalse((boolean)this.filter.accept((Object)new Exception().getClass().getName()));
        Assert.assertTrue((boolean)this.filter.accept((Object)new Throwable().getClass().getName()));
        Assert.assertFalse((boolean)this.filter.accept((Object)new Object().getClass().getName()));
    }
}

