/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.expression.ExpressionManager;
import org.mule.expression.ExpressionConfig;
import org.mule.routing.ExpressionSplitter;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class ExpressionSplitterIteratorTestCase
extends AbstractMuleTestCase {
    private MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
    private final List<Integer> integers = this.createListOfIntegers();
    private final ExpressionConfig expressionConfig = (ExpressionConfig)Mockito.mock(ExpressionConfig.class);
    private final ExpressionSplitter expressionSplitter = new ExpressionSplitter(this.expressionConfig);
    private final MuleConfiguration muleConfiguration = (MuleConfiguration)Mockito.mock(MuleConfiguration.class);

    @Before
    public void setUp() throws Exception {
        this.expressionSplitter.setMuleContext(this.muleContext);
        Mockito.when((Object)this.muleEvent.getMuleContext()).thenReturn((Object)this.muleContext);
        Mockito.when((Object)this.muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
        Mockito.when((Object)this.muleContext.getConfiguration()).thenReturn((Object)this.muleConfiguration);
        Mockito.when((Object)this.expressionConfig.getFullExpression((ExpressionManager)Matchers.any(ExpressionManager.class))).thenReturn((Object)"fullExpression");
        Mockito.when((Object)this.expressionManager.evaluate((String)Matchers.any(String.class), (MuleEvent)Matchers.any(MuleEvent.class))).thenReturn(this.integers.iterator());
    }

    @Test
    public void testExpressionSplitterWithIteratorInput() throws Exception {
        List muleMessages = this.expressionSplitter.splitMessage(this.muleEvent);
        Assert.assertThat((Object)muleMessages.size(), (Matcher)CoreMatchers.is((Object)this.integers.size()));
        this.assertListValues(muleMessages);
    }

    private List<Integer> createListOfIntegers() {
        ArrayList<Integer> integers = new ArrayList<Integer>(3);
        for (int i = 0; i < 3; ++i) {
            integers.add(i);
        }
        return integers;
    }

    private void assertListValues(List<MuleMessage> messages) {
        Integer i = 0;
        for (MuleMessage message : messages) {
            Assert.assertThat((Object)message.getPayload(), (Matcher)CoreMatchers.instanceOf(Integer.class));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            Assert.assertThat((Object)message.getPayload(), (Matcher)CoreMatchers.is((Object)n));
        }
    }
}

