/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.notification.FlowCallStack;
import org.mule.api.context.notification.ProcessorsTrace;
import org.mule.api.security.Credentials;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.ReplyToHandler;
import org.mule.management.stats.ProcessingTime;
import org.mule.message.DefaultExceptionPayload;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContextTestCase
extends AbstractMuleTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestContextTestCase.class);
    private boolean threadSafeEvent;
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

    @Test
    public void testSetExceptionPayloadAcrossThreads() throws InterruptedException {
        this.threadSafeEvent = true;
        DummyEvent event = new DummyEvent();
        this.runThread(event, false);
        this.runThread(event, true);
    }

    @Test
    public void testFailureWithoutThreadSafeEvent() throws InterruptedException {
        this.threadSafeEvent = false;
        DummyEvent event = new DummyEvent();
        this.runThread(event, false);
        this.runThread(event, true);
    }

    protected void runThread(MuleEvent event, boolean doTest) throws InterruptedException {
        AtomicBoolean success = new AtomicBoolean(false);
        Thread thread = new Thread(new SetExceptionPayload(event, success));
        thread.start();
        thread.join();
        if (doTest) {
            Assert.assertEquals((Object)this.threadSafeEvent, (Object)success.get());
        }
    }

    private class DummyEvent
    implements MuleEvent,
    ThreadSafeAccess {
        private MuleMessage message;

        private DummyEvent() {
            this.message = new DefaultMuleMessage(null, RequestContextTestCase.this.muleContext);
        }

        public MuleMessage getMessage() {
            return this.message;
        }

        public Credentials getCredentials() {
            return null;
        }

        public byte[] getMessageAsBytes() throws MuleException {
            return new byte[0];
        }

        public Object transformMessage() throws TransformerException {
            return null;
        }

        public Object transformMessage(Class outputType) throws TransformerException {
            return null;
        }

        @Deprecated
        public byte[] transformMessageToBytes() throws TransformerException {
            return new byte[0];
        }

        public String transformMessageToString() throws TransformerException {
            return null;
        }

        public String getMessageAsString() throws MuleException {
            return null;
        }

        public <T> T transformMessage(DataType<T> outputType) throws TransformerException {
            return null;
        }

        public String getMessageAsString(String encoding) throws MuleException {
            return null;
        }

        public String getId() {
            return null;
        }

        public Object getProperty(String key) {
            return null;
        }

        public Object getProperty(String key, Object defaultValue) {
            return null;
        }

        public MuleSession getSession() {
            return null;
        }

        public FlowConstruct getFlowConstruct() {
            return null;
        }

        public boolean isStopFurtherProcessing() {
            return false;
        }

        public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        }

        public int getTimeout() {
            return 0;
        }

        public void setTimeout(int timeout) {
        }

        public OutputStream getOutputStream() {
            return null;
        }

        public String getEncoding() {
            return null;
        }

        public MuleContext getMuleContext() {
            return null;
        }

        public void assertAccess(boolean write) {
        }

        public void resetAccessControl() {
        }

        public ThreadSafeAccess newThreadCopy() {
            if (RequestContextTestCase.this.threadSafeEvent) {
                return new DummyEvent();
            }
            return this;
        }

        public ProcessingTime getProcessingTime() {
            return null;
        }

        public MessageExchangePattern getExchangePattern() {
            return null;
        }

        public boolean isTransacted() {
            return false;
        }

        public URI getMessageSourceURI() {
            return URI.create("test://test");
        }

        public String getMessageSourceName() {
            return "test";
        }

        public ReplyToHandler getReplyToHandler() {
            return null;
        }

        public Object getReplyToDestination() {
            return null;
        }

        public void captureReplyToDestination() {
        }

        public boolean isSynchronous() {
            return false;
        }

        public void setMessage(MuleMessage message) {
        }

        public DataType<?> getFlowVariableDataType(String key) {
            return null;
        }

        public void clearFlowVariables() {
        }

        public DataType<?> getSessionVariableDataType(String key) {
            return null;
        }

        public Object getFlowVariable(String key) {
            return null;
        }

        public void setFlowVariable(String key, Object value) {
        }

        public void setFlowVariable(String key, Object value, DataType dataType) {
        }

        public void removeFlowVariable(String key) {
        }

        public Set<String> getFlowVariableNames() {
            return Collections.emptySet();
        }

        public Object getSessionVariable(String key) {
            return null;
        }

        public void setSessionVariable(String key, Object value) {
        }

        public void setSessionVariable(String key, Serializable value, DataType dataType) {
        }

        public void removeSessionVariable(String key) {
        }

        public Set<String> getSessionVariableNames() {
            return Collections.emptySet();
        }

        public void clearSessionVariables() {
        }

        public boolean isNotificationsEnabled() {
            return true;
        }

        public void setEnableNotifications(boolean enabled) {
        }

        public boolean isAllowNonBlocking() {
            return false;
        }

        public FlowCallStack getFlowCallStack() {
            return null;
        }

        public ProcessorsTrace getProcessorsTrace() {
            return null;
        }
    }

    private class SetExceptionPayload
    implements Runnable {
        private MuleEvent event;
        private AtomicBoolean success;

        public SetExceptionPayload(MuleEvent event, AtomicBoolean success) {
            this.event = event;
            this.success = success;
        }

        @Override
        public void run() {
            try {
                OptimizedRequestContext.unsafeSetEvent((MuleEvent)this.event);
                RequestContext.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new Exception()));
                this.success.set(true);
            }
            catch (RuntimeException e) {
                LOGGER.error("error in thread", (Throwable)e);
            }
        }
    }
}

