/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.lifecycle.AbstractLifecycleManager;

public class LifecycleTransitionTestCase {
    @Test
    public void testTransitions() throws MuleException {
        ObjectWithLifecycle o = new ObjectWithLifecycle();
        int transitions = 0;
        Assert.assertEquals((long)transitions, (long)o.numTransitions());
        o.initialise();
        Assert.assertEquals((long)(++transitions), (long)o.numTransitions());
        Assert.assertEquals((long)105L, (long)o.lastTransition());
        o.start();
        Assert.assertEquals((long)(++transitions), (long)o.numTransitions());
        Assert.assertEquals((long)97L, (long)o.lastTransition());
        try {
            o.start();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < 5; ++i) {
            o.stop();
            Assert.assertEquals((long)(++transitions), (long)o.numTransitions());
            Assert.assertEquals((long)111L, (long)o.lastTransition());
            o.start();
            Assert.assertEquals((long)(++transitions), (long)o.numTransitions());
            Assert.assertEquals((long)97L, (long)o.lastTransition());
        }
        o.stop();
        Assert.assertEquals((long)(++transitions), (long)o.numTransitions());
        Assert.assertEquals((long)111L, (long)o.lastTransition());
        try {
            o.stop();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        o.dispose();
        Assert.assertEquals((long)(++transitions), (long)o.numTransitions());
        Assert.assertEquals((long)100L, (long)o.lastTransition());
    }

    public static class ObjectWithLifecycle
    implements Lifecycle {
        public static final char INIT = 'i';
        public static final char DISPOSE = 'd';
        public static final char START = 'a';
        public static final char STOP = 'o';
        private LifecycleManager manager = new MyLifecycleManager("this", this);
        private String transitionHistory = "";

        public void dispose() {
            try {
                this.manager.fireLifecycle("dispose");
            }
            catch (LifecycleException e) {
                throw new RuntimeException(e);
            }
        }

        private void doDispose() {
            this.transitionHistory = this.transitionHistory + 'd';
        }

        public void initialise() throws InitialisationException {
            try {
                this.manager.fireLifecycle("initialise");
            }
            catch (LifecycleException e) {
                throw new RuntimeException(e);
            }
        }

        private void doInit() {
            this.transitionHistory = this.transitionHistory + 'i';
        }

        public void start() throws MuleException {
            this.manager.fireLifecycle("start");
        }

        private void doStart() {
            this.transitionHistory = this.transitionHistory + 'a';
        }

        public void stop() throws MuleException {
            this.manager.fireLifecycle("stop");
        }

        private void doStop() {
            this.transitionHistory = this.transitionHistory + 'o';
        }

        public String getTransitionHistory() {
            return this.transitionHistory;
        }

        public int numTransitions() {
            return this.transitionHistory.length();
        }

        public char lastTransition() {
            return this.transitionHistory.length() == 0 ? (char)'\u0000' : this.transitionHistory.charAt(this.transitionHistory.length() - 1);
        }
    }

    public static class MyLifecycleManager
    extends AbstractLifecycleManager {
        public MyLifecycleManager(String id, Object object) {
            super(id, object);
        }

        protected void registerTransitions() {
            this.addDirectTransition("not in lifecycle", "initialise");
            this.addDirectTransition("not in lifecycle", "dispose");
            this.addDirectTransition("initialise", "start");
            this.addDirectTransition("initialise", "dispose");
            this.addDirectTransition("start", "stop");
            this.addDirectTransition("stop", "start");
            this.addDirectTransition("stop", "dispose");
            this.registerLifecycleCallback("initialise", (LifecycleCallback)new LifecycleCallback<ObjectWithLifecycle>(){

                public void onTransition(String phaseName, ObjectWithLifecycle object) {
                    object.doInit();
                }
            });
            this.registerLifecycleCallback("dispose", (LifecycleCallback)new LifecycleCallback<ObjectWithLifecycle>(){

                public void onTransition(String phaseName, ObjectWithLifecycle object) {
                    object.doDispose();
                }
            });
            this.registerLifecycleCallback("start", (LifecycleCallback)new LifecycleCallback<ObjectWithLifecycle>(){

                public void onTransition(String phaseName, ObjectWithLifecycle object) {
                    object.doStart();
                }
            });
            this.registerLifecycleCallback("stop", (LifecycleCallback)new LifecycleCallback<ObjectWithLifecycle>(){

                public void onTransition(String phaseName, ObjectWithLifecycle object) {
                    object.doStop();
                }
            });
        }
    }
}

