/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.expression.VariableExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;

public class VariableExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private static final String CUSTOM_ENCODING = StandardCharsets.UTF_16.name();
    private static final String PROP_NAME = "testProp";
    private static final String PROP_VALUE = "testValue";
    private VariableExpressionEvaluator evaluator = new VariableExpressionEvaluator();

    @Test
    public void evaluatesWithType() throws Exception {
        DataType dataType = DataTypeFactory.create(String.class, (String)"text/json");
        dataType.setEncoding(CUSTOM_ENCODING);
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getProperty(PROP_NAME, PropertyScope.INVOCATION)).thenReturn((Object)PROP_VALUE);
        Mockito.when((Object)message.getPropertyDataType(PROP_NAME, PropertyScope.INVOCATION)).thenReturn((Object)dataType);
        TypedValue typedValue = this.evaluator.evaluateTyped(PROP_NAME, message);
        MatcherAssert.assertThat((Object)((String)typedValue.getValue()), (Matcher)Matchers.equalTo((Object)PROP_VALUE));
        MatcherAssert.assertThat((Object)typedValue.getDataType(), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }

    @Test
    public void evaluatesUnExistentPropertyWithType() throws Exception {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        TypedValue typedValue = this.evaluator.evaluateTyped("UNKNOWN?", message);
        MatcherAssert.assertThat((Object)typedValue.getValue(), (Matcher)Matchers.equalTo(null));
        MatcherAssert.assertThat((Object)typedValue.getDataType(), DataTypeMatcher.like(Object.class, "*/*", null));
    }
}

