/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.expression.MessageProcessorExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MessageProcessorExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private ExpressionManager expressionManager;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.expressionManager = muleContext.getExpressionManager();
        RequestContext.setEvent((MuleEvent)MessageProcessorExpressionEvaluatorTestCase.getTestEvent(""));
        muleContext.getRegistry().registerObject("processor", (Object)new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)(event.getMessageAsString() + "123"));
                return event;
            }
        });
    }

    @Test
    public void testNameOnly() throws Exception {
        MessageProcessorExpressionEvaluator evaluator = new MessageProcessorExpressionEvaluator();
        Assert.assertEquals((Object)"0123", (Object)((MuleMessage)evaluator.evaluate("processor", this.createTestMessage())).getPayloadAsString());
    }

    @Test
    public void testNameOnlyExpressionManager() throws ExpressionRuntimeException, Exception {
        Assert.assertEquals((Object)"0123", (Object)((MuleMessage)this.expressionManager.evaluate("#[process:processor]", this.createTestMessage())).getPayloadAsString());
    }

    @Test
    public void testNestedPayloadExpression() throws Exception {
        MessageProcessorExpressionEvaluator evaluator = new MessageProcessorExpressionEvaluator();
        Assert.assertEquals((Object)"0123", (Object)((MuleMessage)evaluator.evaluate("processor:payload:", this.createTestMessage())).getPayloadAsString());
    }

    @Test
    public void testNestedPayloadExpressionExpressionManager() throws ExpressionRuntimeException, Exception {
        Assert.assertEquals((Object)"0123", (Object)((MuleMessage)this.expressionManager.evaluate("#[process:processor:#[payload:]]", this.createTestMessage())).getPayloadAsString());
    }

    @Test
    public void testNestedHeaderExpression() throws Exception {
        MessageProcessorExpressionEvaluator evaluator = new MessageProcessorExpressionEvaluator();
        Assert.assertEquals((Object)"value123", (Object)((MuleMessage)evaluator.evaluate("processor:header:one", this.createTestMessage())).getPayloadAsString());
    }

    @Test
    public void testNestedHeaderExpressionExpressionManager() throws ExpressionRuntimeException, Exception {
        Assert.assertEquals((Object)"value123", (Object)((MuleMessage)this.expressionManager.evaluate("#[process:processor:#[header:one]]", this.createTestMessage())).getPayloadAsString());
    }

    private MuleMessage createTestMessage() {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"0", muleContext);
        message.setProperty("one", (Object)"value", PropertyScope.OUTBOUND);
        return message;
    }
}

