/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.expression.MessagePayloadExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;

public class MessagePayloadExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private static final String CUSTOM_ENCODING = StandardCharsets.UTF_16.name();
    private static final String PAYLOAD = "test";

    @Test
    public void evaluatesWithType() throws Exception {
        MessagePayloadExpressionEvaluator evaluator = new MessagePayloadExpressionEvaluator();
        DataType dataType = DataTypeFactory.create(String.class, (String)"text/json");
        dataType.setEncoding(CUSTOM_ENCODING);
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getPayload()).thenReturn((Object)PAYLOAD);
        Mockito.when((Object)message.getDataType()).thenReturn((Object)dataType);
        TypedValue typedValue = evaluator.evaluateTyped("", message);
        MatcherAssert.assertThat((Object)((String)typedValue.getValue()), (Matcher)Matchers.equalTo((Object)PAYLOAD));
        MatcherAssert.assertThat((Object)typedValue.getDataType(), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }

    @Test
    public void evaluatesNullMessageWithType() throws Exception {
        MessagePayloadExpressionEvaluator evaluator = new MessagePayloadExpressionEvaluator();
        DataType dataType = DataTypeFactory.create(String.class, (String)"text/json");
        dataType.setEncoding(CUSTOM_ENCODING);
        TypedValue typedValue = evaluator.evaluateTyped("", null);
        MatcherAssert.assertThat((Object)typedValue.getValue(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)typedValue.getDataType(), DataTypeMatcher.like(Object.class, "*/*", null));
    }
}

