/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.expression.DefaultExpressionManager;
import org.mule.expression.ExpressionConfig;
import org.mule.expression.MessageAttachmentExpressionEvaluator;
import org.mule.expression.MessageAttachmentsExpressionEvaluator;
import org.mule.expression.MessageHeaderExpressionEvaluator;
import org.mule.expression.MessageHeadersExpressionEvaluator;
import org.mule.expression.StringExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.types.TypedValue;

public class ExpressionConfigTestCase
extends AbstractMuleContextTestCase {
    private DefaultExpressionManager expressionManager;

    @Before
    public void setup() throws InitialisationException {
        this.expressionManager = new DefaultExpressionManager();
        this.expressionManager.setMuleContext(muleContext);
        this.expressionManager.registerEvaluator((ExpressionEvaluator)new MessageHeaderExpressionEvaluator());
        this.expressionManager.registerEvaluator((ExpressionEvaluator)new MessageHeadersExpressionEvaluator());
        this.expressionManager.registerEvaluator((ExpressionEvaluator)new MessageAttachmentExpressionEvaluator());
        this.expressionManager.registerEvaluator((ExpressionEvaluator)new MessageAttachmentsExpressionEvaluator());
        this.expressionManager.initialise();
    }

    @Test
    public void testConfig() throws Exception {
        ExpressionConfig config = new ExpressionConfig("foo=bar", "header", null, "$[", "]");
        Assert.assertEquals((Object)"$[header:foo=bar]", (Object)config.getFullExpression((ExpressionManager)this.expressionManager));
        config = new ExpressionConfig("foo,bar", "headers", null);
        Assert.assertEquals((Object)"#[headers:foo,bar]", (Object)config.getFullExpression((ExpressionManager)this.expressionManager));
        config = new ExpressionConfig();
        config.parse("#[attachment:baz]");
        Assert.assertEquals((Object)"attachment", (Object)config.getEvaluator());
        Assert.assertEquals((Object)"baz", (Object)config.getExpression());
        Assert.assertNull((Object)config.getCustomEvaluator());
    }

    @Test
    public void testCustomConfig() throws Exception {
        this.expressionManager.registerEvaluator(new ExpressionEvaluator(){

            public Object evaluate(String expression, MuleMessage message) {
                return null;
            }

            public TypedValue evaluateTyped(String expression, MuleMessage message) {
                return null;
            }

            public void setName(String name) {
            }

            public String getName() {
                return "customEval";
            }
        });
        ExpressionConfig config = new ExpressionConfig("foo,bar", "custom", "customEval");
        Assert.assertEquals((Object)"#[customEval:foo,bar]", (Object)config.getFullExpression((ExpressionManager)this.expressionManager));
    }

    @Test
    public void testExpressionOnlyConfig() throws Exception {
        ExpressionConfig config = new ExpressionConfig("header:foo=bar", null, null, "$[", "]");
        Assert.assertEquals((Object)"$[header:foo=bar]", (Object)config.getFullExpression((ExpressionManager)this.expressionManager));
        config = new ExpressionConfig("headers:foo,bar", null, null);
        Assert.assertEquals((Object)"#[headers:foo,bar]", (Object)config.getFullExpression((ExpressionManager)this.expressionManager));
        config = new ExpressionConfig();
        config.parse("#[attachment:baz]");
        Assert.assertEquals((Object)"attachment", (Object)config.getEvaluator());
        Assert.assertEquals((Object)"baz", (Object)config.getExpression());
        Assert.assertNull((Object)config.getCustomEvaluator());
    }

    @Test
    public void testExpressionLanguageExpression() throws Exception {
        ExpressionConfig config = new ExpressionConfig("message.inboundProperty['foo']=='bar'", null, null, "$[", "]");
        Assert.assertEquals((Object)"$[message.inboundProperty['foo']=='bar']", (Object)config.getFullExpression((ExpressionManager)this.expressionManager));
        config = new ExpressionConfig();
        config.parse("#[message.inboundAttachment['baz']]");
        Assert.assertEquals(null, (Object)config.getEvaluator());
        Assert.assertEquals((Object)"message.inboundAttachment['baz']", (Object)config.getExpression());
        Assert.assertNull((Object)config.getCustomEvaluator());
    }

    @Test
    public void testEvaluatorExpressionOnly() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("header:foo");
        Assert.assertEquals((Object)"header", (Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"foo", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[header:foo]", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
        expressionConfig.validate((ExpressionManager)this.expressionManager);
    }

    @Test
    public void testEvaluatorExpressionOnlyWithBrackets() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("#[header:foo]");
        Assert.assertEquals((Object)"header", (Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"foo", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[header:foo]", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
    }

    @Test
    public void testELExpression() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("message.payload");
        Assert.assertNull((Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"message.payload", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[message.payload]", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
    }

    @Test
    public void testELExpressionWithBrackets() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("#[message.payload]");
        Assert.assertNull((Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"message.payload", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[message.payload]", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
    }

    @Test
    public void testELExpressionWithTenaryIf() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("1==1?true:false");
        Assert.assertNull((Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"1==1?true:false", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[1==1?true:false]", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
    }

    @Test
    public void testELExpressionWithForeach() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("for(a:[1,2,3){'1'}");
        Assert.assertNull((Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"for(a:[1,2,3){'1'}", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[for(a:[1,2,3){'1'}]", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
    }

    @Test
    public void testELExpressionWithColonInString() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("'This is a message : msg'");
        Assert.assertNull((Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"'This is a message : msg'", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#['This is a message : msg']", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
    }

    @Test
    public void testXPathExpressionWithNamesapce() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("//this:other/@attr");
        expressionConfig.setEvaluator("header");
        Assert.assertEquals((Object)"header", (Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"//this:other/@attr", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[header://this:other/@attr]", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
    }

    @Test
    public void testXPathExpressionWithNamesapce2() {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setEvaluator("header");
        expressionConfig.setExpression("//this:other/@attr");
        Assert.assertEquals((Object)"header", (Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"//this:other/@attr", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[header://this:other/@attr]", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
    }

    @Test
    public void testNestedExpression() {
        muleContext.getExpressionManager().registerEvaluator((ExpressionEvaluator)new StringExpressionEvaluator());
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("#[header:#[header:foo]]");
        Assert.assertEquals((Object)"header", (Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"#[header:foo]", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[header:#[header:foo]]", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
    }

    @Test
    public void testSetExpressionTwice() {
        muleContext.getExpressionManager().registerEvaluator((ExpressionEvaluator)new StringExpressionEvaluator());
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.setExpression("#[header:this]");
        expressionConfig.setExpression("#[header:other]");
        Assert.assertEquals((Object)"header", (Object)expressionConfig.getEvaluator());
        Assert.assertNull((Object)expressionConfig.getCustomEvaluator());
        Assert.assertEquals((Object)"other", (Object)expressionConfig.getExpression());
        Assert.assertEquals((Object)"#[header:other]", (Object)expressionConfig.getFullExpression((ExpressionManager)this.expressionManager));
    }
}

