/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.junit.Assert;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.StringDataSource;

public abstract class AbstractAttachmentsTestCase
extends AbstractMuleContextTestCase {
    protected MuleMessage message;

    public AbstractAttachmentsTestCase() {
        this.setDisposeContextPerClass(true);
    }

    @Override
    protected void doSetUp() throws Exception {
        Map<String, DataHandler> attachments = this.createAttachmentsMap();
        this.message = new DefaultMuleMessage((Object)"Test Message", null, attachments, muleContext);
    }

    protected Map<String, DataHandler> createAttachmentsMap() {
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        attachments.put("foo", new DataHandler((DataSource)new StringDataSource("foovalue")));
        attachments.put("bar", new DataHandler((DataSource)new StringDataSource("barvalue")));
        attachments.put("baz", new DataHandler((DataSource)new StringDataSource("bazvalue")));
        return attachments;
    }

    protected void assertAttachmentValueEquals(String expected, Object attachment) throws IOException {
        Assert.assertTrue((boolean)(attachment instanceof DataHandler));
        DataHandler dataHandler = (DataHandler)attachment;
        String attachmentString = this.attachmentToString(dataHandler);
        Assert.assertEquals((Object)expected, (Object)attachmentString);
    }

    protected String attachmentToString(DataHandler dataHandler) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        dataHandler.writeTo((OutputStream)baos);
        return baos.toString();
    }
}

