/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.MimeType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageExtension;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.expression.InvalidExpressionException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.DataType;
import org.mule.config.MuleManifest;
import org.mule.el.context.AppContext;
import org.mule.el.context.MessageContext;
import org.mule.el.function.RegexExpressionLanguageFuntion;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.PropertyAccessException;
import org.mule.mvel2.ast.Function;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.optimizers.OptimizerFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;

@RunWith(value=Parameterized.class)
public class MVELExpressionLanguageTestCase
extends AbstractMuleContextTestCase {
    protected Variant variant;
    protected MVELExpressionLanguage mvel;
    final String largeExpression = "payload = 'Tom,Fennelly,Male,4,Ireland';StringBuilder sb = new StringBuilder(); fields = payload.split(',');if (fields.length > 4) {    sb.append('  <Contact>\n');    sb.append('    <FirstName>').append(fields[0]).append('</FirstName>\n');    sb.append('    <LastName>').append(fields[1]).append('</LastName>\n');    sb.append('    <Address>').append(fields[2]).append('</Address>\n');    sb.append('    <TelNum>').append(fields[3]).append('</TelNum>\n');    sb.append('    <SIN>').append(fields[4]).append('</SIN>\n');    sb.append('  </Contact>\n');}sb.toString();";

    public MVELExpressionLanguageTestCase(Variant variant, String mvelOptimizer) {
        this.variant = variant;
        OptimizerFactory.setDefaultOptimizer((String)mvelOptimizer);
    }

    @Before
    public void setupMVEL() throws InitialisationException {
        this.mvel = new MVELExpressionLanguage(muleContext);
        this.mvel.initialise();
    }

    @Test
    public void testEvaluateString() {
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'"));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2"));
        Assert.assertEquals((Object)"hiho", (Object)this.evaluate("'hi'+'ho'"));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone"));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version"));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name"));
    }

    @Test
    public void testEvaluateStringMapOfStringObject() {
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'", Collections.emptyMap()));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2", Collections.emptyMap()));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone", Collections.emptyMap()));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version", Collections.emptyMap()));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name", Collections.emptyMap()));
        Assert.assertEquals((Object)1, (Object)this.evaluate("foo", Collections.singletonMap("foo", 1)));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo", Collections.singletonMap("foo", "bar")));
    }

    @Test
    public void testEvaluateStringMuleEvent() {
        MuleEvent event = this.createMockEvent();
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'", event));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2", event));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone", event));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version", event));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name", event));
        Assert.assertEquals((Object)"myFlow", (Object)this.evaluate("flow.name", event));
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.payload", event));
    }

    @Test
    public void testEvaluateStringMuleEventMapOfStringObject() {
        MuleEvent event = this.createMockEvent();
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'", event));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2", event));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone", event));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version", event));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name", event));
        Assert.assertEquals((Object)"myFlow", (Object)this.evaluate("flow.name", event));
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.payload", event));
        Assert.assertEquals((Object)1, (Object)this.evaluate("foo", Collections.singletonMap("foo", 1)));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo", Collections.singletonMap("foo", "bar")));
    }

    @Test
    public void testEvaluateStringMuleMessage() {
        MuleMessage message = this.createMockMessage();
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'", message));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2", message));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone", message));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version", message));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name", message));
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.payload", message));
    }

    @Test
    public void testEvaluateStringMuleMessageMapOfStringObject() {
        MuleMessage message = this.createMockMessage();
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("'hi'", message));
        Assert.assertEquals((Object)4, (Object)this.evaluate("2*2", message));
        Assert.assertEquals((Object)Calendar.getInstance().getTimeZone(), (Object)this.evaluate("server.timeZone", message));
        Assert.assertEquals((Object)MuleManifest.getProductVersion(), (Object)this.evaluate("mule.version", message));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("app.name", message));
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("message.payload", message));
        Assert.assertEquals((Object)1, (Object)this.evaluate("foo", Collections.singletonMap("foo", 1)));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo", Collections.singletonMap("foo", "bar")));
    }

    @Test
    public void testIsValid() {
        Assert.assertTrue((boolean)this.mvel.isValid("2*2"));
    }

    @Test
    public void testIsValidInvalid() {
        Assert.assertFalse((boolean)this.mvel.isValid("2*'2"));
    }

    @Test
    public void testValidate() {
        this.validate("2*2");
    }

    @Test(expected=InvalidExpressionException.class)
    public void testValidateInvalid() {
        this.validate("2*'2");
    }

    @Test
    public void regexFunction() {
        Assert.assertEquals((Object)"foo", (Object)this.evaluate("regex('TEST(\\\\w+)TEST')", (MuleMessage)new DefaultMuleMessage((Object)"TESTfooTEST", muleContext)));
    }

    @Test
    public void appTakesPrecedenceOverEverything() throws RegistrationException, InitialisationException {
        this.mvel.setAliases(Collections.singletonMap("app", "'other1'"));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setInvocationProperty("app", (Object)"otherb");
        muleContext.getRegistry().registerObject("foo", (Object)new ExpressionLanguageExtension(){

            public void configureContext(ExpressionLanguageContext context) {
                context.addVariable("app", (Object)"otherc");
            }
        });
        this.mvel.initialise();
        Assert.assertEquals(AppContext.class, this.evaluate("app").getClass());
    }

    @Test
    public void messageTakesPrecedenceOverEverything() throws RegistrationException, InitialisationException {
        this.mvel.setAliases(Collections.singletonMap("message", "'other1'"));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setInvocationProperty("message", (Object)"other2");
        muleContext.getRegistry().registerObject("foo", (Object)new ExpressionLanguageExtension(){

            public void configureContext(ExpressionLanguageContext context) {
                context.addVariable("message", (Object)"other3");
            }
        });
        this.mvel.initialise();
        Assert.assertEquals(MessageContext.class, this.evaluate("message", (MuleMessage)message).getClass());
    }

    @Test
    public void extensionTakesPrecedenceOverAutoResolved() throws RegistrationException, InitialisationException {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setInvocationProperty("foo", (Object)"other");
        muleContext.getRegistry().registerObject("key", (Object)new ExpressionLanguageExtension(){

            public void configureContext(ExpressionLanguageContext context) {
                context.addVariable("foo", (Object)"bar");
            }
        });
        this.mvel.initialise();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo", (MuleMessage)message));
    }

    @Test
    public void aliasTakesPrecedenceOverAutoResolved() throws RegistrationException, InitialisationException {
        this.mvel.setAliases(Collections.singletonMap("foo", "'bar'"));
        muleContext.getRegistry().registerObject("key", (Object)new ExpressionLanguageExtension(){

            public void configureContext(ExpressionLanguageContext context) {
                context.addVariable("foo", (Object)"other");
            }
        });
        this.mvel.initialise();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo"));
    }

    @Test
    public void aliasTakesPrecedenceOverExtension() throws RegistrationException, InitialisationException {
        this.mvel.setAliases(Collections.singletonMap("foo", "'bar'"));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        message.setInvocationProperty("foo", (Object)"other");
        this.mvel.initialise();
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("foo"));
    }

    @Test
    public void addImport() throws InitialisationException {
        this.mvel.setImports(Collections.singletonMap("loc", Locale.class));
        this.mvel.initialise();
        Assert.assertEquals(Locale.class, (Object)this.evaluate("loc"));
    }

    @Test
    public void addAlias() throws InitialisationException {
        this.mvel.setAliases(Collections.singletonMap("appName", "app.name"));
        this.mvel.initialise();
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("appName"));
    }

    @Test
    public void addGlobalFunction() throws InitialisationException {
        this.mvel.addGlobalFunction("hello", (Function)new HelloWorldFunction(new ParserContext(this.mvel.parserConfiguration)));
        this.mvel.initialise();
        Assert.assertEquals((Object)"Hello World!", (Object)this.evaluate("hello()"));
    }

    @Test
    public void defaultImports() throws InitialisationException, ClassNotFoundException, IOException {
        Assert.assertEquals(InputStream.class, (Object)this.evaluate(InputStream.class.getSimpleName()));
        Assert.assertEquals(FileReader.class, (Object)this.evaluate(FileReader.class.getSimpleName()));
        Assert.assertEquals(Object.class, (Object)this.evaluate(Object.class.getSimpleName()));
        Assert.assertEquals(System.class, (Object)this.evaluate(System.class.getSimpleName()));
        Assert.assertEquals(URI.class, (Object)this.evaluate(URI.class.getSimpleName()));
        Assert.assertEquals(URL.class, (Object)this.evaluate(URL.class.getSimpleName()));
        Assert.assertEquals(Collection.class, (Object)this.evaluate(Collection.class.getSimpleName()));
        Assert.assertEquals(List.class, (Object)this.evaluate(List.class.getSimpleName()));
        Assert.assertEquals(BigDecimal.class, (Object)this.evaluate(BigDecimal.class.getSimpleName()));
        Assert.assertEquals(BigInteger.class, (Object)this.evaluate(BigInteger.class.getSimpleName()));
        Assert.assertEquals(DataHandler.class, (Object)this.evaluate(DataHandler.class.getSimpleName()));
        Assert.assertEquals(MimeType.class, (Object)this.evaluate(MimeType.class.getSimpleName()));
        Assert.assertEquals(Pattern.class, (Object)this.evaluate(Pattern.class.getSimpleName()));
        Assert.assertEquals(DataType.class, (Object)this.evaluate(DataType.class.getSimpleName()));
        Assert.assertEquals(DataTypeFactory.class, (Object)this.evaluate(DataTypeFactory.class.getSimpleName()));
    }

    @Test
    public void testConcurrentCompilation() throws Exception {
        int N = 100;
        final CountDownLatch start = new CountDownLatch(1);
        final CountDownLatch end = new CountDownLatch(100);
        final AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 100; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        start.await();
                        MVELExpressionLanguageTestCase.this.evaluate("payload = 'Tom,Fennelly,Male,4,Ireland';StringBuilder sb = new StringBuilder(); fields = payload.split(',');if (fields.length > 4) {    sb.append('  <Contact>\n');    sb.append('    <FirstName>').append(fields[0]).append('</FirstName>\n');    sb.append('    <LastName>').append(fields[1]).append('</LastName>\n');    sb.append('    <Address>').append(fields[2]).append('</Address>\n');    sb.append('    <TelNum>').append(fields[3]).append('</TelNum>\n');    sb.append('    <SIN>').append(fields[4]).append('</SIN>\n');    sb.append('  </Contact>\n');}sb.toString();" + new Random().nextInt());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                    finally {
                        end.countDown();
                    }
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        end.await();
        if (errors.get() > 0) {
            Assert.fail();
        }
    }

    @Test
    public void testConcurrentEvaluation() throws Exception {
        int N = 100;
        final CountDownLatch start = new CountDownLatch(1);
        final CountDownLatch end = new CountDownLatch(100);
        final AtomicInteger errors = new AtomicInteger(0);
        for (int i = 0; i < 100; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        start.await();
                        MVELExpressionLanguageTestCase.this.testEvaluateString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                    finally {
                        end.countDown();
                    }
                }
            }, "thread-eval-" + i).start();
        }
        start.countDown();
        end.await();
        if (errors.get() > 0) {
            Assert.fail();
        }
    }

    @Test
    public void propertyAccessException() throws InitialisationException {
        try {
            this.evaluate("doesntExist");
        }
        catch (Exception e) {
            Assert.assertEquals(ExpressionRuntimeException.class, e.getClass());
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(CompileException.class));
        }
    }

    @Test
    public void propertyAccessException2() throws InitialisationException {
        try {
            this.evaluate("app.doesntExist");
        }
        catch (Exception e) {
            Assert.assertEquals(ExpressionRuntimeException.class, e.getClass());
            Assert.assertEquals(PropertyAccessException.class, e.getCause().getClass());
        }
    }

    @Test
    public void returnsDataType() throws Exception {
        DataType dataType = DataTypeFactory.create(String.class, (String)"text/json");
        dataType.setEncoding(StandardCharsets.UTF_16.name());
        MuleMessage message = this.createMockMessage("Test Message", dataType);
        TypedValue typedValue = this.evaluateTyped("payload", message);
        Assert.assertThat((Object)((String)typedValue.getValue()), (Matcher)CoreMatchers.equalTo((Object)"Test Message"));
        Assert.assertThat((Object)typedValue.getDataType(), DataTypeMatcher.like(String.class, "text/json", StandardCharsets.UTF_16.name()));
    }

    protected Object evaluate(String expression) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluate("#[" + expression + "]");
        }
        return this.mvel.evaluate(expression);
    }

    protected TypedValue evaluateTyped(String expression, MuleMessage message) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluateTyped("#[" + expression + "]", message);
        }
        return this.mvel.evaluateTyped(expression, message);
    }

    protected Object evaluate(String expression, Map<String, Object> vars) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluate("#[" + expression + "]", vars);
        }
        return this.mvel.evaluate(expression, vars);
    }

    protected Object evaluate(String expression, MuleMessage message) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluate("#[" + expression + "]", message);
        }
        return this.mvel.evaluate(expression, message);
    }

    protected Object evaluate(String expression, MuleEvent event) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            return this.mvel.evaluate("#[" + expression + "]", event);
        }
        return this.mvel.evaluate(expression, event);
    }

    protected void validate(String expression) {
        if (this.variant.equals((Object)Variant.EXPRESSION_WITH_DELIMITER)) {
            this.mvel.validate("#[" + expression + "]");
        } else {
            this.mvel.validate(expression);
        }
    }

    protected MuleEvent createMockEvent() {
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)flowConstruct.getName()).thenReturn((Object)"myFlow");
        MuleMessage message = this.createMockMessage();
        Mockito.when((Object)event.getFlowConstruct()).thenReturn((Object)flowConstruct);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        return event;
    }

    protected MuleMessage createMockMessage() {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getPayload()).thenReturn((Object)"foo");
        return message;
    }

    protected MuleMessage createMockMessage(Object payload, DataType dataType) {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getPayload()).thenReturn(payload);
        Mockito.when((Object)message.getDataType()).thenReturn((Object)dataType);
        return message;
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return Arrays.asList({Variant.EXPRESSION_WITH_DELIMITER, OptimizerFactory.SAFE_REFLECTIVE}, {Variant.EXPRESSION_WITH_DELIMITER, OptimizerFactory.DYNAMIC}, {Variant.EXPRESSION_STRAIGHT_UP, OptimizerFactory.SAFE_REFLECTIVE}, {Variant.EXPRESSION_STRAIGHT_UP, OptimizerFactory.DYNAMIC});
    }

    private static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(MVELExpressionLanguageTestCase.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    @Test
    public void collectionAccessPayloadChangedMULE7506() throws Exception {
        MuleEvent event = MVELExpressionLanguageTestCase.getTestEvent(new String[]{"1", "2"});
        Assert.assertEquals((Object)"1", (Object)this.mvel.evaluate("payload[0]", event));
        event.getMessage().setPayload(Collections.singletonList("1"));
        Assert.assertEquals((Object)"1", (Object)this.mvel.evaluate("payload[0]", event));
    }

    private static class HelloWorldFunction
    extends Function {
        public HelloWorldFunction(ParserContext parserContext) {
            super("hello", new char[0], 0, 0, 0, 0, 0, parserContext);
        }

        public Object call(Object ctx, Object thisValue, VariableResolverFactory factory, Object[] parms) {
            return "Hello World!";
        }
    }

    public static enum Variant {
        EXPRESSION_WITH_DELIMITER,
        EXPRESSION_STRAIGHT_UP;

    }

    static class DummyExpressionLanguageExtension
    implements ExpressionLanguageExtension {
        DummyExpressionLanguageExtension() {
        }

        public void configureContext(ExpressionLanguageContext context) {
            for (int i = 0; i < 20; ++i) {
                context.declareFunction("dummy-function-" + i, (ExpressionLanguageFunction)new RegexExpressionLanguageFuntion());
            }
        }
    }
}

