/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DynamicDataTypeConversionResolver;
import org.mule.api.MuleContext;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.builder.MockConverterBuilder;
import org.mule.transformer.types.DataTypeFactory;

@SmallTest
public class DynamicDataTypeConverterResolverTestCase
extends AbstractMuleTestCase {
    private MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);

    @Test
    public void doesNotFailWhenThereIsNoDataTypeResolution() throws TransformerException {
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.muleRegistry);
        Mockito.when((Object)this.muleRegistry.lookupTransformer((DataType)Mockito.any(DataType.class), (DataType)Mockito.any(DataType.class))).thenReturn(null);
        DynamicDataTypeConversionResolver resolver = new DynamicDataTypeConversionResolver(this.muleContext);
        ArrayList<DataType> targetTypes = new ArrayList<DataType>();
        targetTypes.add(DataTypeFactory.STRING);
        Transformer resolvedConverter = resolver.resolve(DataTypeFactory.INPUT_STREAM, targetTypes);
        Assert.assertEquals(null, (Object)resolvedConverter);
    }

    @Test
    public void findsExpectedConverter() throws TransformerException {
        Converter expectedConverter = ((MockConverterBuilder)((MockConverterBuilder)new MockConverterBuilder().from(DataTypeFactory.BYTE_ARRAY)).to(DataTypeFactory.STRING)).build();
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.muleRegistry);
        Mockito.when((Object)this.muleRegistry.lookupTransformer(DataTypeFactory.BYTE_ARRAY, DataTypeFactory.STRING)).thenReturn((Object)expectedConverter);
        DynamicDataTypeConversionResolver resolver = new DynamicDataTypeConversionResolver(this.muleContext);
        ArrayList<DataType> targetTypes = new ArrayList<DataType>();
        targetTypes.add(DataTypeFactory.INPUT_STREAM);
        targetTypes.add(DataTypeFactory.STRING);
        Transformer resolvedConverter = resolver.resolve(DataTypeFactory.BYTE_ARRAY, targetTypes);
        Assert.assertEquals((Object)expectedConverter, (Object)resolvedConverter);
    }
}

