/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling.watermark;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.InvalidExpressionException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.store.ObjectStore;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.polling.MessageProcessorPollingInterceptor;
import org.mule.transport.polling.watermark.Watermark;
import org.mule.transport.polling.watermark.WatermarkPollingInterceptor;
import org.mule.transport.polling.watermark.WatermarkUtils;

public class UpdateExpressionWatermark
extends Watermark
implements Initialisable,
MuleContextAware {
    private final String updateExpression;
    private final MessageProcessorPollingInterceptor interceptor;
    private MuleContext muleContext;

    public UpdateExpressionWatermark(ObjectStore<Serializable> objectStore, String variable, String defaultExpression, String updateExpression) {
        super(objectStore, variable, defaultExpression);
        this.updateExpression = updateExpression;
        this.interceptor = new WatermarkPollingInterceptor(this);
    }

    @Override
    public void initialise() throws InitialisationException {
        if (!StringUtils.isEmpty((String)this.updateExpression)) {
            try {
                this.muleContext.getExpressionManager().validateExpression(this.updateExpression);
            }
            catch (InvalidExpressionException e) {
                throw new InitialisationException(MessageFactory.createStaticMessage(String.format("update-expression requires a valid MEL expression. '%s' was found instead", this.updateExpression)), (Throwable)e, this);
            }
        }
    }

    @Override
    protected Object getUpdatedValue(MuleEvent event) {
        try {
            return StringUtils.isEmpty((String)this.updateExpression) ? event.getFlowVariable(this.resolveVariable(event)) : WatermarkUtils.evaluate(this.updateExpression, event);
        }
        catch (NotSerializableException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public MessageProcessorPollingInterceptor interceptor() {
        return this.interceptor;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

