/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.text.MessageFormat;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.AttributeEvaluator;

public class AddAttachmentTransformer
extends AbstractMessageTransformer {
    private AttributeEvaluator nameEvaluator;
    private AttributeEvaluator valueEvaluator;
    private AttributeEvaluator contentTypeEvaluator;

    public AddAttachmentTransformer() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.nameEvaluator.initialize(this.muleContext.getExpressionManager());
        this.valueEvaluator.initialize(this.muleContext.getExpressionManager());
        this.contentTypeEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            Object keyValue = this.nameEvaluator.resolveValue(message);
            if (keyValue == null) {
                this.logger.error((Object)"Setting Null attachment key is not supported, this entry is being ignored");
            } else {
                String key = keyValue.toString();
                Object value = this.valueEvaluator.resolveValue(message);
                if (value == null) {
                    this.logger.error((Object)MessageFormat.format("Attachment with key ''{0}'', not found on message using ''{1}''. Since the value was marked optional, nothing was set on the message for this attachment", key, this.valueEvaluator.getRawValue()));
                } else {
                    String contentType = this.contentTypeEvaluator.resolveValue(message).toString();
                    message.addOutboundAttachment(key, value, contentType);
                }
            }
            return message;
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AddAttachmentTransformer clone = (AddAttachmentTransformer)super.clone();
        clone.setName(this.nameEvaluator.getRawValue());
        clone.setValue(this.valueEvaluator.getRawValue());
        return clone;
    }

    public void setAttachmentName(String attachmentName) {
        this.nameEvaluator = new AttributeEvaluator(attachmentName);
    }

    public void setValue(String value) {
        this.valueEvaluator = new AttributeEvaluator(value);
    }

    public void setContentType(String contentType) {
        this.contentTypeEvaluator = new AttributeEvaluator(contentType);
    }
}

