/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.exception.MessagingExceptionHandlerAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.store.ListableObjectStore;
import org.mule.config.i18n.MessageFactory;
import org.mule.processor.chain.DefaultMessageProcessorChain;
import org.mule.routing.AsynchronousUntilSuccessfulProcessingStrategy;
import org.mule.routing.SynchronousUntilSuccessfulProcessingStrategy;
import org.mule.routing.UntilSuccessfulConfiguration;
import org.mule.routing.UntilSuccessfulProcessingStrategy;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.util.Preconditions;
import org.mule.util.concurrent.NamedThreadFactory;

public class UntilSuccessful
extends AbstractOutboundRouter
implements UntilSuccessfulConfiguration {
    public static final String PROCESS_ATTEMPT_COUNT_PROPERTY_NAME = "process.attempt.count";
    static final int DEFAULT_PROCESS_ATTEMPT_COUNT_PROPERTY_VALUE = 1;
    private static final long DEFAULT_MILLIS_BETWEEN_RETRIES = 60000L;
    private ListableObjectStore<MuleEvent> objectStore;
    private int maxRetries = 5;
    private Long millisBetweenRetries = null;
    private Long secondsBetweenRetries = null;
    private String failureExpression;
    private String ackExpression;
    private ExpressionFilter failureExpressionFilter;
    private String eventKeyPrefix;
    private Object deadLetterQueue;
    private MessageProcessor dlqMP;
    private boolean synchronous = false;
    private ThreadingProfile threadingProfile;
    private UntilSuccessfulProcessingStrategy untilSuccessfulStrategy;

    @Override
    public void initialise() throws InitialisationException {
        if (this.routes.isEmpty()) {
            throw new InitialisationException(MessageFactory.createStaticMessage("One message processor must be configured within UntilSuccessful."), (Initialisable)this);
        }
        if (this.routes.size() > 1) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Only one message processor is allowed within UntilSuccessful. Use a Processor Chain to group several message processors into one."), (Initialisable)this);
        }
        this.setWaitTime();
        super.initialise();
        if (this.deadLetterQueue != null) {
            if (this.deadLetterQueue instanceof EndpointBuilder) {
                try {
                    this.dlqMP = ((EndpointBuilder)this.deadLetterQueue).buildOutboundEndpoint();
                }
                catch (EndpointException ee) {
                    throw new InitialisationException(MessageFactory.createStaticMessage("deadLetterQueue-ref is not a valid endpoint builder: " + this.deadLetterQueue), (Throwable)ee, this);
                }
            } else if (this.deadLetterQueue instanceof MessageProcessor) {
                this.dlqMP = (MessageProcessor)this.deadLetterQueue;
            } else {
                throw new InitialisationException(MessageFactory.createStaticMessage("deadLetterQueue-ref is not a valid mesage processor: " + this.deadLetterQueue), null, this);
            }
        }
        this.failureExpressionFilter = this.failureExpression != null ? new ExpressionFilter(this.failureExpression) : new ExpressionFilter("exception-type:");
        this.failureExpressionFilter.setMuleContext(this.muleContext);
        if (this.ackExpression != null && !this.muleContext.getExpressionManager().isExpression(this.ackExpression)) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Invalid ackExpression: " + this.ackExpression), (Initialisable)this);
        }
        if (this.synchronous) {
            this.untilSuccessfulStrategy = new SynchronousUntilSuccessfulProcessingStrategy();
        } else {
            if (this.threadingProfile == null) {
                this.threadingProfile = this.muleContext.getDefaultThreadingProfile();
            }
            this.untilSuccessfulStrategy = new AsynchronousUntilSuccessfulProcessingStrategy();
            ((MessagingExceptionHandlerAware)((Object)this.untilSuccessfulStrategy)).setMessagingExceptionHandler(this.messagingExceptionHandler);
        }
        this.untilSuccessfulStrategy.setUntilSuccessfulConfiguration(this);
        if (this.untilSuccessfulStrategy instanceof Initialisable) {
            ((Initialisable)((Object)this.untilSuccessfulStrategy)).initialise();
        }
        String flowName = this.flowConstruct.getName();
        String clusterId = this.muleContext.getClusterId();
        this.eventKeyPrefix = flowName + "-" + clusterId + "-";
    }

    private void setWaitTime() {
        boolean hasSeconds = this.secondsBetweenRetries != null;
        boolean hasMillis = this.millisBetweenRetries != null;
        Preconditions.checkArgument(!hasSeconds || !hasMillis, "Can't specify millisBetweenRetries and secondsBetweenRetries properties at the same time. Please specify only one and remember that secondsBetweenRetries is deprecated.");
        if (hasSeconds) {
            this.logger.warn((Object)"You're using the secondsBetweenRetries in the until-successful router. That attribute was deprecated in favor of the new millisBetweenRetries.Please consider updating your config since the old attribute will be removed in Mule 4");
            this.setMillisBetweenRetries(TimeUnit.SECONDS.toMillis(this.secondsBetweenRetries));
        } else if (!hasMillis) {
            this.millisBetweenRetries = 60000L;
        }
    }

    @Override
    public void start() throws MuleException {
        super.start();
        if (this.untilSuccessfulStrategy instanceof Startable) {
            ((Startable)((Object)this.untilSuccessfulStrategy)).start();
        }
    }

    @Override
    public ScheduledThreadPoolExecutor createScheduledRetriesPool(String threadPrefix) {
        return new ScheduledThreadPoolExecutor(1, new NamedThreadFactory(threadPrefix + "_retries", Thread.currentThread().getContextClassLoader()));
    }

    @Override
    public void stop() throws MuleException {
        if (this.untilSuccessfulStrategy instanceof Stoppable) {
            ((Stoppable)((Object)this.untilSuccessfulStrategy)).stop();
        }
        super.stop();
    }

    @Override
    public boolean isMatch(MuleMessage message) throws MuleException {
        return true;
    }

    @Override
    protected MuleEvent route(MuleEvent event) throws MessagingException {
        return this.untilSuccessfulStrategy.route(event);
    }

    @Override
    public ListableObjectStore<MuleEvent> getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ListableObjectStore<MuleEvent> objectStore) {
        this.objectStore = objectStore;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Deprecated
    public void setSecondsBetweenRetries(long secondsBetweenRetries) {
        this.secondsBetweenRetries = secondsBetweenRetries;
    }

    @Override
    public long getMillisBetweenRetries() {
        return this.millisBetweenRetries;
    }

    public void setMillisBetweenRetries(long millisBetweenRetries) {
        this.millisBetweenRetries = millisBetweenRetries;
    }

    public String getFailureExpression() {
        return this.failureExpression;
    }

    public void setFailureExpression(String failureExpression) {
        this.failureExpression = failureExpression;
    }

    @Override
    public String getAckExpression() {
        return this.ackExpression;
    }

    public void setAckExpression(String ackExpression) {
        this.ackExpression = ackExpression;
    }

    public void setDeadLetterQueue(Object deadLetterQueue) {
        this.deadLetterQueue = deadLetterQueue;
    }

    public Object getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public String getEventKeyPrefix() {
        return this.eventKeyPrefix;
    }

    @Override
    public ExpressionFilter getFailureExpressionFilter() {
        return this.failureExpressionFilter;
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    @Override
    public ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }

    @Override
    public MessageProcessor getDlqMP() {
        return this.dlqMP;
    }

    @Override
    public MessageProcessor getRoute() {
        return DefaultMessageProcessorChain.from((MessageProcessor)this.routes.get(0));
    }

    @Override
    public AbstractOutboundRouter getRouter() {
        return this;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

