/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.strategy;

import org.mule.api.MuleContext;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.config.ChainedThreadingProfile;
import org.mule.util.concurrent.ThreadNameHelper;

public abstract class AbstractThreadingProfileProcessingStrategy
implements ProcessingStrategy {
    protected Integer maxThreads;
    protected Integer minThreads;
    protected Integer maxBufferSize;
    protected Long threadTTL;
    protected Long threadWaitTimeout;
    protected Integer poolExhaustedAction;

    protected ThreadingProfile createThreadingProfile(MuleContext muleContext) {
        ChainedThreadingProfile threadingProfile = new ChainedThreadingProfile(muleContext.getDefaultThreadingProfile());
        if (this.maxThreads != null) {
            threadingProfile.setMaxThreadsActive(this.maxThreads);
        }
        if (this.minThreads != null) {
            threadingProfile.setMaxThreadsIdle(this.minThreads);
        }
        if (this.maxBufferSize != null) {
            threadingProfile.setMaxBufferSize(this.maxBufferSize);
        }
        if (this.threadTTL != null) {
            threadingProfile.setThreadTTL(this.threadTTL);
        }
        if (this.threadWaitTimeout != null) {
            threadingProfile.setThreadWaitTimeout(this.threadWaitTimeout);
        }
        if (this.poolExhaustedAction != null) {
            threadingProfile.setPoolExhaustedAction(this.poolExhaustedAction);
        }
        threadingProfile.setMuleContext(muleContext);
        return threadingProfile;
    }

    protected String getThreadPoolName(String stageName, MuleContext muleContext) {
        return ThreadNameHelper.flow(muleContext, stageName);
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public void setMaxBufferSize(Integer maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    public void setThreadTTL(Long threadTTL) {
        this.threadTTL = threadTTL;
    }

    public void setThreadWaitTimeout(Long threadWaitTimeout) {
        this.threadWaitTimeout = threadWaitTimeout;
    }

    public void setPoolExhaustedAction(Integer poolExhaustedAction) {
        this.poolExhaustedAction = poolExhaustedAction;
    }

    public Integer getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public Long getThreadTTL() {
        return this.threadTTL;
    }

    public Long getThreadWaitTimeout() {
        return this.threadWaitTimeout;
    }

    public Integer getPoolExhaustedAction() {
        return this.poolExhaustedAction;
    }
}

