/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.AbstractExpressionEvaluator;
import org.mule.util.StringUtils;

public class MessageProcessorExpressionEvaluator
extends AbstractExpressionEvaluator {
    protected transient Log logger = LogFactory.getLog(MessageProcessorExpressionEvaluator.class);
    public static final String NAME = "process";

    @Override
    public Object evaluate(String expression, MuleMessage message) {
        String processorName;
        boolean isNestedExpression;
        MuleContext muleContext = message.getMuleContext();
        String processorArgExpression = null;
        MuleMessage messageToProcess = message;
        if (StringUtils.isBlank((String)expression)) {
            return message;
        }
        boolean bl = isNestedExpression = expression.indexOf(58) > 0;
        if (!isNestedExpression) {
            processorName = expression;
        } else {
            processorName = expression.substring(0, expression.indexOf(58));
            processorArgExpression = expression.substring(expression.indexOf(58) + 1, expression.length());
        }
        if (processorArgExpression != null) {
            messageToProcess = this.evaluateProcessorArgument(message, processorArgExpression);
        }
        MessageProcessor processor = this.lookupMessageProcessor(processorName, muleContext);
        try {
            return processor.process(new DefaultMuleEvent(messageToProcess, RequestContext.getEvent())).getMessage();
        }
        catch (MuleException e) {
            throw new ExpressionRuntimeException(CoreMessages.createStaticMessage("Exception invoking MessageProcessor '" + processorName + "'"), (Throwable)e);
        }
    }

    protected MessageProcessor lookupMessageProcessor(String processorName, MuleContext muleContext) {
        Object processor = muleContext.getRegistry().lookupObject(processorName);
        if (!(processor instanceof MessageProcessor)) {
            throw new ExpressionRuntimeException(CoreMessages.createStaticMessage("No MessageProcessor '" + processorName + "' found."));
        }
        return (MessageProcessor)processor;
    }

    protected MuleMessage evaluateProcessorArgument(MuleMessage message, String processorArgExpression) {
        Object result = message.getMuleContext().getExpressionManager().evaluate(processorArgExpression, message);
        if (result instanceof MuleMessage) {
            return (MuleMessage)result;
        }
        return new DefaultMuleMessage(result, message.getMuleContext());
    }

    @Override
    public String getName() {
        return NAME;
    }
}

