/*
 * Decompiled with CFR 0.152.
 */
package org.mule.execution;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RequestContext;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.context.notification.ConnectorMessageNotification;
import org.mule.context.notification.NotificationHelper;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.execution.MessageProcessPhase;
import org.mule.execution.MessageProcessTemplate;

public abstract class NotificationFiringProcessingPhase<Template extends MessageProcessTemplate>
implements MessageProcessPhase<Template>,
Comparable<MessageProcessPhase>,
MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private ConcurrentHashMap<ServerNotificationManager, NotificationHelper> notificationHelpers = new ConcurrentHashMap();
    private MuleContext muleContext;

    protected void fireNotification(MuleEvent event, int action) {
        try {
            if ((event == null || VoidMuleEvent.getInstance().equals(event)) && ((event = RequestContext.getEvent()) == null || VoidMuleEvent.getInstance().equals(event))) {
                return;
            }
            this.getNotificationHelper(this.muleContext.getNotificationManager()).fireNotification(event, event.getMessageSourceURI() != null ? event.getMessageSourceURI().toString() : null, event.getFlowConstruct(), action);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Could not fire notification. Action: " + action), (Throwable)e);
        }
    }

    protected NotificationHelper getNotificationHelper(ServerNotificationManager serverNotificationManager) {
        NotificationHelper notificationHelper = this.notificationHelpers.get(serverNotificationManager);
        if (notificationHelper == null) {
            notificationHelper = new NotificationHelper(serverNotificationManager, ConnectorMessageNotification.class, false);
            this.notificationHelpers.putIfAbsent(serverNotificationManager, notificationHelper);
        }
        return notificationHelper;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

