/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.LoggerContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.FlowStackElement;
import org.mule.api.context.notification.FlowTraceManager;
import org.mule.api.execution.LocationExecutionContextProvider;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.context.notification.DefaultFlowCallStack;
import org.mule.context.notification.DefaultProcessorsTrace;
import org.mule.context.notification.FlowNotificationTextDebugger;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.context.notification.MessageProcessorTextDebugger;
import org.mule.context.notification.PipelineMessageNotification;
import org.mule.logging.LogConfigChangeSubject;

public class MessageProcessingFlowTraceManager
extends LocationExecutionContextProvider
implements FlowTraceManager,
MuleContextAware,
Initialisable,
Disposable {
    public static final String FLOW_STACK_INFO_KEY = "FlowStack";
    private final FlowNotificationTextDebugger pipelineProcessorDebugger;
    private final MessageProcessorTextDebugger messageProcessorTextDebugger;
    private MuleContext muleContext;
    private PropertyChangeListener logConfigChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MessageProcessingFlowTraceManager.this.handleNotificationListeners();
        }
    };

    public MessageProcessingFlowTraceManager() {
        this.messageProcessorTextDebugger = new MessageProcessorTextDebugger(this);
        this.pipelineProcessorDebugger = new FlowNotificationTextDebugger(this);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        LoggerContext context = LogManager.getContext((boolean)false);
        if (context != null && context instanceof LogConfigChangeSubject) {
            ((LogConfigChangeSubject)context).registerLogConfigChangeListener(this.logConfigChangeListener);
        }
        this.handleNotificationListeners();
    }

    @Override
    public void dispose() {
        LoggerContext context = LogManager.getContext((boolean)false);
        if (context != null && context instanceof LogConfigChangeSubject) {
            ((LogConfigChangeSubject)context).unregisterLogConfigChangeListener(this.logConfigChangeListener);
        }
        this.removeNotificationListeners();
    }

    protected void handleNotificationListeners() {
        if (DefaultMuleConfiguration.isFlowTrace()) {
            this.muleContext.getNotificationManager().addListener(this.messageProcessorTextDebugger);
            this.muleContext.getNotificationManager().addListener(this.pipelineProcessorDebugger);
        } else {
            this.removeNotificationListeners();
        }
    }

    protected void removeNotificationListeners() {
        this.muleContext.getNotificationManager().removeListener(this.messageProcessorTextDebugger);
        this.muleContext.getNotificationManager().removeListener(this.pipelineProcessorDebugger);
    }

    public void onMessageProcessorNotificationPreInvoke(MessageProcessorNotification notification) {
        String resolveProcessorRepresentation = MessageProcessingFlowTraceManager.resolveProcessorRepresentation(this.muleContext.getConfiguration().getId(), notification.getProcessorPath(), notification.getProcessor());
        if (notification.getSource().getProcessorsTrace() instanceof DefaultProcessorsTrace) {
            ((DefaultProcessorsTrace)notification.getSource().getProcessorsTrace()).addExecutedProcessors(resolveProcessorRepresentation);
        }
        if (notification.getSource().getFlowCallStack() instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)notification.getSource().getFlowCallStack()).setCurrentProcessorPath(resolveProcessorRepresentation);
        }
    }

    public void onPipelineNotificationComplete(PipelineMessageNotification notification) {
        this.onFlowComplete((MuleEvent)notification.getSource());
    }

    public void onPipelineNotificationStart(PipelineMessageNotification notification) {
        this.onFlowStart((MuleEvent)notification.getSource(), notification.getResourceIdentifier());
    }

    @Override
    public void onFlowStart(MuleEvent muleEvent, String flowName) {
        if (muleEvent.getFlowCallStack() instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)muleEvent.getFlowCallStack()).push(new FlowStackElement(flowName, null));
        }
    }

    @Override
    public void onFlowComplete(MuleEvent muleEvent) {
        if (muleEvent.getFlowCallStack() instanceof DefaultFlowCallStack) {
            ((DefaultFlowCallStack)muleEvent.getFlowCallStack()).pop();
        }
    }

    @Override
    public Map<String, Object> getContextInfo(MuleEvent muleEvent, MessageProcessor lastProcessed) {
        if (DefaultMuleConfiguration.isFlowTrace()) {
            return Collections.singletonMap(FLOW_STACK_INFO_KEY, muleEvent.getFlowCallStack().toString());
        }
        return Collections.emptyMap();
    }
}

