/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.polling;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.schedule.Scheduler;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.NullPayload;
import org.mule.transport.polling.MessageProcessorPollingMessageReceiver;
import org.mule.transport.polling.schedule.FixedFrequencySchedulerFactory;

public class MessageProcessorPollingMessageReceiverTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testNullResponseFromNestedMP() throws Exception {
        MessageProcessorPollingMessageReceiver receiver = this.createReceiver(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return null;
            }
        });
        SensingNullMessageProcessor flow = this.getSensingNullMessageProcessor();
        receiver.setListener((MessageProcessor)flow);
        receiver.poll();
        Assert.assertNull((Object)flow.event);
    }

    @Test
    public void testNullPayloadResponseFromNestedMP() throws Exception {
        MessageProcessorPollingMessageReceiver receiver = this.createReceiver(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)NullPayload.getInstance(), muleContext), event);
            }
        });
        SensingNullMessageProcessor flow = this.getSensingNullMessageProcessor();
        receiver.setListener((MessageProcessor)flow);
        receiver.poll();
        Assert.assertNull((Object)flow.event);
    }

    @Test
    public void testEmptyStringResponseFromNestedMP() throws Exception {
        MessageProcessorPollingMessageReceiver receiver = this.createReceiver(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"", muleContext), event);
            }
        });
        SensingNullMessageProcessor flow = this.getSensingNullMessageProcessor();
        receiver.setListener((MessageProcessor)flow);
        receiver.poll();
        Assert.assertNotNull((Object)flow.event);
    }

    @Test
    public void testNestedOneWayEndpoint() throws Exception {
        try {
            this.createReceiver((MessageProcessor)muleContext.getEndpointFactory().getOutboundEndpoint("test://test2"));
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals(InitialisationException.class, e.getClass());
        }
    }

    @Test
    public void disposeScheduler() throws Exception {
        MessageProcessorPollingMessageReceiver receiver = this.createReceiver(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return null;
            }
        });
        Collection<Scheduler> allSchedulers = this.getAllSchedulers();
        Assert.assertThat((Object)allSchedulers.size(), (Matcher)Matchers.is((Object)1));
        Scheduler scheduler = allSchedulers.iterator().next();
        receiver.stop();
        receiver.dispose();
        Assert.assertThat((Object)this.getAllSchedulers().size(), (Matcher)Matchers.is((Object)0));
        ((Scheduler)Mockito.verify((Object)scheduler)).dispose();
    }

    private Collection<Scheduler> getAllSchedulers() {
        return muleContext.getRegistry().lookupObjects(Scheduler.class);
    }

    private MessageProcessorPollingMessageReceiver createReceiver(MessageProcessor processor) throws MuleException {
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("test://test", muleContext);
        builder.setProperty((Object)"MULE_ENDPOINT__sourceMessageProcessor", (Object)processor);
        builder.setProperty((Object)"MULE_ENDPOINT__schedulerFactory", (Object)this.schedulerFactory());
        InboundEndpoint inboundEndpoint = muleContext.getEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)flowConstruct.getMuleContext()).thenReturn((Object)muleContext);
        MessageProcessorPollingMessageReceiver receiver = new MessageProcessorPollingMessageReceiver(inboundEndpoint.getConnector(), flowConstruct, inboundEndpoint);
        receiver.initialise();
        return receiver;
    }

    private FixedFrequencySchedulerFactory schedulerFactory() {
        FixedFrequencySchedulerFactory factory = new FixedFrequencySchedulerFactory(){

            protected Scheduler doCreate(String name, Runnable job) {
                return (Scheduler)Mockito.spy((Object)super.doCreate(name, job));
            }
        };
        factory.setFrequency(1000L);
        factory.setMuleContext(muleContext);
        return factory;
    }
}

