/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.function;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.el.ExpressionExecutor;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.el.context.MessageContext;
import org.mule.el.function.WildcardExpressionLanguageFuntion;
import org.mule.el.mvel.MVELExpressionExecutor;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserConfiguration;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class WildcardExpressionLanguageFunctionTestCase
extends AbstractMuleTestCase {
    protected ExpressionExecutor<MVELExpressionLanguageContext> expressionExecutor;
    protected MVELExpressionLanguageContext context;
    protected WildcardExpressionLanguageFuntion wildcardFunction;

    @Before
    public void setup() throws InitialisationException {
        ParserConfiguration parserConfiguration = new ParserConfiguration();
        this.expressionExecutor = new MVELExpressionExecutor(parserConfiguration);
        this.context = new MVELExpressionLanguageContext(parserConfiguration, (MuleContext)Mockito.mock(MuleContext.class));
        this.wildcardFunction = new WildcardExpressionLanguageFuntion();
        this.context.declareFunction("wildcard", (ExpressionLanguageFunction)this.wildcardFunction);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatches() throws Exception {
        this.addMessageToContextWithPayload("TEST");
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"'*ASDF*QWER*'"}, (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesMVEL() throws Exception {
        this.addMessageToContextWithPayload("TEST");
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('*ASDF*QWER*')", (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatches() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"TEST*TEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesMVEL() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('TEST*TEST')", (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgument() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"'*ASDF*QWER*'", "TEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgumentMVEL() throws Exception {
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('*ASDF*QWER*', 'TEST')", (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgument() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"TEST*TEST", "TESTfooTEST"}, (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgumentMVEL() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('TEST*TEST', 'TESTfooTEST')", (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgumentAndSensitivityIsTrue() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"'tes*'", "TEST", true}, (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgumentAndSensitivityMVELIsTrue() throws Exception {
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('tes?', 'TEST', true)", (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgumentAndSensitivityIsFalse() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"'*ASDF*QWER*'", "TEST", false}, (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnFalseWhenDoesNotMatchesDefinedTextArgumentAndSensitivityMVELIsFalse() throws Exception {
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('*ASDF*QWER*', 'TEST', false)", (ExpressionLanguageContext)this.context);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgumentAndSensitivityIsTrue() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"test*TEST", "testfooTEST", true}, (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgumentAndSensitivityMVELIsTrue() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('test*TEST', 'testfooTEST', true)", (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgumentAndSensitivityIsFalse() throws Exception {
        boolean result = (Boolean)this.wildcardFunction.call(new Object[]{"TEST*test", "testfooTEST", false}, (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testReturnsTrueWhenMatchesDefinedTextArgumentAndSensitivityMVELIsFalse() throws Exception {
        this.addMessageToContextWithPayload("TESTfooTEST");
        boolean result = (Boolean)this.expressionExecutor.execute("wildcard('TEST???test', 'testfooTEST', false)", (ExpressionLanguageContext)this.context);
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNullPattern() throws Exception {
        this.wildcardFunction.call(new Object[]{null}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNullPatternMVEL() throws Exception {
        this.expressionExecutor.execute("wildcard(null)", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNonStringPattern() throws Exception {
        this.wildcardFunction.call(new Object[]{new Date()}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNonStringWildcardPatternMVEL() throws Exception {
        this.expressionExecutor.execute("wildcard(new java.util.Date())", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNullText() throws Exception {
        this.wildcardFunction.call(new Object[]{"TEST*TEST", null}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNullTextMVEL() throws Exception {
        this.expressionExecutor.execute("wildcard('TEST*TEST',null)", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidNonStringText() throws Exception {
        this.wildcardFunction.call(new Object[]{"TEST*TEST", new Date()}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidNonStringTextMVEL() throws Exception {
        this.expressionExecutor.execute("wildcard('TEST*TEST',new Date())", (ExpressionLanguageContext)this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidBlankStringText() throws Exception {
        this.wildcardFunction.call(new Object[]{"", "testfooTEST"}, (ExpressionLanguageContext)this.context);
    }

    @Test(expected=CompileException.class)
    public void testInvalidBlankStringTextMVEL() throws Exception {
        this.expressionExecutor.execute("wildcard('', 'testfooTEST')", (ExpressionLanguageContext)this.context);
    }

    protected void addMessageToContextWithPayload(String payload) throws TransformerException {
        MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)message.getPayload((Class)Mockito.any(Class.class))).thenReturn((Object)payload);
        this.context.addFinalVariable("message", (Object)new MessageContext(message));
    }
}

