/*
 * Decompiled with CFR 0.152.
 */
package org.mule.work;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.ResponseTimeoutException;
import org.mule.config.i18n.MessageFactory;
import org.mule.work.AbstractMuleEventWork;

public class ProcessingMuleEventWork
extends AbstractMuleEventWork {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final MessageProcessor messageProcessor;
    private MuleEvent resultEvent;
    private MuleException exception;

    public ProcessingMuleEventWork(MessageProcessor messageProcessor, MuleEvent muleEvent) {
        super(muleEvent);
        this.messageProcessor = messageProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        try {
            this.resultEvent = this.messageProcessor.process(this.event);
        }
        catch (MuleException e) {
            this.exception = e;
        }
        finally {
            this.latch.countDown();
        }
    }

    public MuleEvent getResult(long timeout, TimeUnit timeUnit) throws InterruptedException, ResponseTimeoutException, MuleException {
        if (this.latch.await(timeout, timeUnit)) {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.resultEvent;
        }
        throw new ResponseTimeoutException(MessageFactory.createStaticMessage("Processing did not completed in time"), this.event, this.messageProcessor);
    }
}

