/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.monitor;

import java.beans.ExceptionListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.mule.util.monitor.FileListener;

public class FileMonitor {
    private Timer timer;
    private Map<File, Long> files = new HashMap<File, Long>();
    private List<WeakReference<FileListener>> listeners = new ArrayList<WeakReference<FileListener>>();
    private long pollingInterval;

    public FileMonitor(long pollingInterval) {
        this.timer = new Timer(true);
        this.pollingInterval = pollingInterval;
    }

    public void stop() {
        this.timer.cancel();
    }

    public void start() {
        this.timer.schedule((TimerTask)new FileMonitorNotifier(), 0L, this.pollingInterval);
    }

    public void addFile(File file) {
        if (!this.files.containsKey(file)) {
            long modifiedTime = file.exists() ? file.lastModified() : -1L;
            this.files.put(file, new Long(modifiedTime));
        }
    }

    public void removeFile(File file) {
        this.files.remove(file);
    }

    public void addListener(FileListener fileListener) {
        for (WeakReference<FileListener> reference : this.listeners) {
            FileListener listener = (FileListener)reference.get();
            if (listener != fileListener) continue;
            return;
        }
        this.listeners.add(new WeakReference<FileListener>(fileListener));
    }

    public void removeListener(FileListener fileListener) {
        Iterator<WeakReference<FileListener>> i = this.listeners.iterator();
        while (i.hasNext()) {
            WeakReference<FileListener> reference = i.next();
            FileListener listener = (FileListener)reference.get();
            if (listener != fileListener) continue;
            i.remove();
            break;
        }
    }

    public class FileMonitorNotifier
    extends TimerTask {
        private ExceptionListener exceptionListener;

        public FileMonitorNotifier() {
        }

        public FileMonitorNotifier(ExceptionListener exceptionListener) {
            this.exceptionListener = exceptionListener;
        }

        @Override
        public void run() {
            ArrayList fileKeys = new ArrayList(FileMonitor.this.files.keySet());
            for (File file : fileKeys) {
                long lastModifiedTime = (Long)FileMonitor.this.files.get(file);
                long newModifiedTime = file.exists() ? file.lastModified() : -1L;
                if (newModifiedTime == lastModifiedTime) continue;
                FileMonitor.this.files.put(file, new Long(newModifiedTime));
                Iterator j = FileMonitor.this.listeners.iterator();
                while (j.hasNext()) {
                    WeakReference reference = (WeakReference)j.next();
                    FileListener listener = (FileListener)reference.get();
                    if (listener == null) {
                        j.remove();
                        continue;
                    }
                    try {
                        listener.fileChanged(file);
                    }
                    catch (IOException e) {
                        if (this.exceptionListener == null) continue;
                        this.exceptionListener.exceptionThrown(e);
                    }
                }
            }
        }
    }
}

