/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.AttributeEvaluator;

public abstract class AbstractAddVariablePropertyTransformer
extends AbstractMessageTransformer {
    private AttributeEvaluator identifierEvaluator;
    private AttributeEvaluator valueEvaluator;

    public AbstractAddVariablePropertyTransformer() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.setReturnDataType(DataTypeFactory.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.identifierEvaluator.initialize(this.muleContext.getExpressionManager());
        this.valueEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Object keyValue = this.identifierEvaluator.resolveValue(message);
        String key = keyValue == null ? null : keyValue.toString();
        message.setProperty(key, this.valueEvaluator.resolveValue(message), this.getScope());
        return message;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractAddVariablePropertyTransformer clone = (AbstractAddVariablePropertyTransformer)super.clone();
        clone.setIdentifier(this.identifierEvaluator.getRawValue());
        clone.setValue(this.valueEvaluator.getRawValue());
        return clone;
    }

    public void setIdentifier(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        this.identifierEvaluator = new AttributeEvaluator(identifier);
    }

    public void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        this.valueEvaluator = new AttributeEvaluator(value);
    }

    protected abstract PropertyScope getScope();
}

