/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.routing.RoutingException;
import org.mule.api.transformer.TransformerException;
import org.mule.routing.IdempotentMessageFilter;
import org.mule.transformer.simple.ByteArrayToHexString;
import org.mule.transformer.simple.SerializableToByteArray;

public class IdempotentSecureHashMessageFilter
extends IdempotentMessageFilter {
    private String messageDigestAlgorithm = "SHA-256";
    private final SerializableToByteArray objectToByteArray = new SerializableToByteArray();
    private final ByteArrayToHexString byteArrayToHexString = new ByteArrayToHexString();

    @Override
    protected String getIdForEvent(MuleEvent event) throws MessagingException {
        try {
            Object payload = event.getMessage().getPayload();
            byte[] bytes = (byte[])this.objectToByteArray.transform(payload);
            MessageDigest md = MessageDigest.getInstance(this.messageDigestAlgorithm);
            byte[] digestedBytes = md.digest(bytes);
            return (String)this.byteArrayToHexString.transform(digestedBytes);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new RoutingException(event, this, (Throwable)nsa);
        }
        catch (TransformerException te) {
            throw new RoutingException(event, this, (Throwable)te);
        }
    }

    public String getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }
}

