/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle.phases;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.PreDestroy;
import org.mule.api.agent.Agent;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.Model;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.source.MessageSource;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.MuleContextNotification;
import org.mule.lifecycle.LifecycleObject;
import org.mule.lifecycle.NotificationLifecycleObject;
import org.mule.lifecycle.phases.DefaultLifecyclePhase;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

public class MuleContextDisposePhase
extends DefaultLifecyclePhase {
    public MuleContextDisposePhase() {
        super("dispose", Disposable.class, "initialise");
        LinkedHashSet<LifecycleObject> orderedObjects = new LinkedHashSet<LifecycleObject>();
        orderedObjects.add(new NotificationLifecycleObject(FlowConstruct.class));
        orderedObjects.add(new NotificationLifecycleObject(Model.class, MuleContextNotification.class));
        orderedObjects.add(new NotificationLifecycleObject(Agent.class));
        orderedObjects.add(new NotificationLifecycleObject(Connector.class));
        orderedObjects.add(new NotificationLifecycleObject(Stoppable.class));
        orderedObjects.add(new NotificationLifecycleObject(Object.class));
        this.registerSupportedPhase("all");
        this.setOrderedLifecycleObjects(orderedObjects);
        this.setIgnoredObjectTypes(new Class[]{Component.class, MessageSource.class, OutboundRouterCollection.class, OutboundRouter.class, Transformer.class});
    }

    @Override
    public void applyLifecycle(Object o) throws LifecycleException {
        if (o == null) {
            return;
        }
        if (this.ignoreType(o.getClass())) {
            return;
        }
        super.applyLifecycle(o);
        List<AnnotationMetaData> annos = AnnotationUtils.getMethodAnnotations(o.getClass(), PreDestroy.class);
        if (annos.size() == 0) {
            return;
        }
        AnnotationMetaData anno = annos.get(0);
        try {
            ((Method)anno.getMember()).invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToInvokeLifecycle(anno == null ? "null" : anno.getMember().getName(), o), e, this);
        }
    }
}

