/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.File;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.FileUtils;
import org.mule.util.store.TextFileObjectStore;

public class TextFileStoreTestCase
extends AbstractMuleContextTestCase {
    public static final String DIR = ".mule/temp";
    TextFileObjectStore store;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        FileUtils.deleteTree((File)new File(DIR));
    }

    @Override
    protected void doTearDown() throws Exception {
        if (this.store != null) {
            this.store.dispose();
        }
        FileUtils.deleteTree((File)new File(DIR));
        super.doTearDown();
    }

    @Test
    public void testTimedExpiry() throws Exception {
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(3000);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        this.store.store((Serializable)((Object)"1"), "1");
        this.store.store((Serializable)((Object)"2"), "2");
        this.store.store((Serializable)((Object)"3"), "3");
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"1")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"2")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"3")));
        Thread.sleep(4000L);
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"1")));
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"2")));
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"3")));
    }

    @Test
    public void testTimedExpiryWithRestart() throws Exception {
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(3000);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        this.store.store((Serializable)((Object)"1"), "1");
        this.store.store((Serializable)((Object)"2"), "2");
        this.store.store((Serializable)((Object)"3"), "3");
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"1")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"2")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"3")));
        this.store.dispose();
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(3000);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"1")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"2")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"3")));
        Thread.sleep(4000L);
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"1")));
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"2")));
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"3")));
        this.store.dispose();
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(3000);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"1")));
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"2")));
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"3")));
    }

    @Test
    public void testTimedExpiryWithObjects() throws Exception {
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("timed");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(3000);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
    }

    @Test
    public void testMaxSize() throws Exception {
        this.store = new TextFileObjectStore();
        this.store.setDirectory(DIR);
        this.store.setMuleContext(muleContext);
        this.store.setName("bounded");
        this.store.setMaxEntries(3);
        this.store.setEntryTTL(-1);
        this.store.setExpirationInterval(1000);
        this.store.initialise();
        this.store.store((Serializable)((Object)"1"), "1");
        this.store.store((Serializable)((Object)"2"), "2");
        this.store.store((Serializable)((Object)"3"), "3");
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"1")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"2")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"3")));
        Thread.sleep(3000L);
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"1")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"2")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"3")));
        this.store.store((Serializable)((Object)"4"), "4");
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"1")));
        this.store.expire();
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"1")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"2")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"3")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"4")));
        this.store.store((Serializable)((Object)"5"), "5");
        this.store.expire();
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"2")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"3")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"4")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"5")));
        this.store.store((Serializable)((Object)"6"), "6");
        this.store.store((Serializable)((Object)"7"), "7");
        this.store.store((Serializable)((Object)"8"), "8");
        this.store.store((Serializable)((Object)"9"), "9");
        this.store.expire();
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"7")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"8")));
        Assert.assertTrue((boolean)this.store.contains((Serializable)((Object)"9")));
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"3")));
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"4")));
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"5")));
        Assert.assertFalse((boolean)this.store.contains((Serializable)((Object)"6")));
    }
}

