/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.queue.DefaultQueueConfiguration;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueSession;

public class TransactionalQueueManagerTestCase
extends AbstractMuleContextTestCase {
    public static final String TEST_QUEUE_NAME = "queue1";

    @Test
    public void allowChangingConfigurationOnDisposedQueue() throws Exception {
        muleContext.start();
        QueueManager queueManager = muleContext.getQueueManager();
        queueManager.setQueueConfiguration(TEST_QUEUE_NAME, (QueueConfiguration)new DefaultQueueConfiguration(0, true));
        QueueSession queueSession = queueManager.getQueueSession();
        Queue queue = queueSession.getQueue(TEST_QUEUE_NAME);
        queue.dispose();
        queueManager.setQueueConfiguration(TEST_QUEUE_NAME, (QueueConfiguration)new DefaultQueueConfiguration(0, false));
    }

    @Test
    public void clearRecoveryQueuesAfterRecovery() throws Exception {
        muleContext.start();
        this.createDanglingTx();
        QueueManager queueManager = muleContext.getQueueManager();
        QueueSession queueSession = queueManager.getQueueSession();
        queueSession.getQueue(TEST_QUEUE_NAME).dispose();
        queueManager.setQueueConfiguration(TEST_QUEUE_NAME, (QueueConfiguration)new DefaultQueueConfiguration());
        queueManager.start();
    }

    private void createDanglingTx() throws InterruptedException, MuleException {
        QueueManager queueManager = muleContext.getQueueManager();
        queueManager.setDefaultQueueConfiguration((QueueConfiguration)new DefaultQueueConfiguration(0, true));
        QueueSession queueSession = queueManager.getQueueSession();
        queueSession.getQueue(TEST_QUEUE_NAME).put((Serializable)((Object)"value"));
        queueSession.begin();
        queueSession.getQueue(TEST_QUEUE_NAME).poll(10L);
        queueManager.stop();
    }
}

