/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.ObjectUtils;
import org.mule.util.StringUtils;

@SmallTest
public class ObjectUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testIdentityToShortString() {
        Assert.assertEquals((Object)"null", (Object)ObjectUtils.identityToShortString(null));
        String source = "foo";
        String description = ObjectUtils.identityToShortString((Object)source);
        String[] components = StringUtils.split((String)description, (char)'@');
        Assert.assertNotNull((Object)components);
        Assert.assertEquals((long)2L, (long)components.length);
        Assert.assertEquals((Object)"String", (Object)components[0]);
        Assert.assertEquals((Object)Integer.toHexString(System.identityHashCode(source)), (Object)components[1]);
    }

    @Test
    public void testBooleanConversion() throws Exception {
        Object value = "true";
        Assert.assertTrue((boolean)ObjectUtils.getBoolean((Object)value, (Boolean)false));
        value = "xyz";
        Assert.assertFalse((boolean)ObjectUtils.getBoolean((Object)value, (Boolean)false));
        value = new Integer(6);
        Assert.assertTrue((boolean)ObjectUtils.getBoolean((Object)value, (Boolean)false));
        value = new Integer(1);
        Assert.assertTrue((boolean)ObjectUtils.getBoolean((Object)value, (Boolean)false));
        value = new Integer(0);
        Assert.assertFalse((boolean)ObjectUtils.getBoolean((Object)value, (Boolean)false));
        value = new Integer(-41);
        Assert.assertFalse((boolean)ObjectUtils.getBoolean((Object)value, (Boolean)false));
        value = null;
        Assert.assertFalse((boolean)ObjectUtils.getBoolean((Object)value, (Boolean)false));
    }

    @Test
    public void testShortConversion() throws Exception {
        Object value = "123";
        Assert.assertEquals((long)123L, (long)ObjectUtils.getShort((Object)value, (Short)-1));
        value = "xyz";
        Assert.assertEquals((long)-1L, (long)ObjectUtils.getShort((Object)value, (Short)-1));
        value = new Integer(6);
        Assert.assertEquals((long)6L, (long)ObjectUtils.getShort((Object)value, (Short)-1));
        value = new Double(63.4);
        Assert.assertEquals((long)63L, (long)ObjectUtils.getShort((Object)value, (Short)-1));
        value = new Float(-163.2);
        Assert.assertEquals((long)-163L, (long)ObjectUtils.getShort((Object)value, (Short)-1));
        value = null;
        Assert.assertEquals((long)-1L, (long)ObjectUtils.getShort((Object)value, (Short)-1));
    }

    @Test
    public void testByteConversion() throws Exception {
        Object value = "123";
        Assert.assertEquals((long)123L, (long)ObjectUtils.getByte((Object)value, (Byte)-1));
        value = "xyz";
        Assert.assertEquals((long)-1L, (long)ObjectUtils.getByte((Object)value, (Byte)-1));
        value = new Integer(6);
        Assert.assertEquals((long)6L, (long)ObjectUtils.getByte((Object)value, (Byte)-1));
        value = new Double(63.4);
        Assert.assertEquals((long)63L, (long)ObjectUtils.getByte((Object)value, (Byte)-1));
        value = new Float(-163.2);
        Assert.assertEquals((long)93L, (long)ObjectUtils.getByte((Object)value, (Byte)-1));
        value = null;
        Assert.assertEquals((long)-1L, (long)ObjectUtils.getByte((Object)value, (Byte)-1));
    }

    @Test
    public void testIntConversion() throws Exception {
        Object value = "123";
        Assert.assertEquals((long)123L, (long)ObjectUtils.getInt((Object)value, (Integer)-1));
        value = "xyz";
        Assert.assertEquals((long)-1L, (long)ObjectUtils.getInt((Object)value, (Integer)-1));
        value = new Integer(6);
        Assert.assertEquals((long)6L, (long)ObjectUtils.getInt((Object)value, (Integer)-1));
        value = new Double(63.4);
        Assert.assertEquals((long)63L, (long)ObjectUtils.getInt((Object)value, (Integer)-1));
        value = new Float(-163.2);
        Assert.assertEquals((long)-163L, (long)ObjectUtils.getInt((Object)value, (Integer)-1));
        value = null;
        Assert.assertEquals((long)-1L, (long)ObjectUtils.getInt((Object)value, (Integer)-1));
    }

    @Test
    public void testLongConversion() throws Exception {
        Object value = "123";
        Assert.assertEquals((long)123L, (long)ObjectUtils.getLong((Object)value, (Long)-1L));
        value = "xyz";
        Assert.assertEquals((long)-1L, (long)ObjectUtils.getLong((Object)value, (Long)-1L));
        value = new Integer(6);
        Assert.assertEquals((long)6L, (long)ObjectUtils.getLong((Object)value, (Long)-1L));
        value = new Double(63.4);
        Assert.assertEquals((long)63L, (long)ObjectUtils.getLong((Object)value, (Long)-1L));
        value = new Float(-163.2);
        Assert.assertEquals((long)-163L, (long)ObjectUtils.getLong((Object)value, (Long)-1L));
        value = null;
        Assert.assertEquals((long)-1L, (long)ObjectUtils.getLong((Object)value, (Long)-1L));
    }

    @Test
    public void testFloatConversion() throws Exception {
        Object value = "123.34";
        Assert.assertEquals((double)123.34, (double)ObjectUtils.getFloat((Object)value, (Float)Float.valueOf(-1.0f)), (double)0.1f);
        value = "xyz";
        Assert.assertEquals((double)-1.0, (double)ObjectUtils.getFloat((Object)value, (Float)Float.valueOf(-1.0f)), (double)0.1f);
        value = new Integer(6);
        Assert.assertEquals((double)6.0, (double)ObjectUtils.getFloat((Object)value, (Float)Float.valueOf(-1.0f)), (double)0.1f);
        value = new Double(63.4);
        Assert.assertEquals((double)63.4, (double)ObjectUtils.getFloat((Object)value, (Float)Float.valueOf(-1.0f)), (double)0.1f);
        value = new Float(-163.2);
        Assert.assertEquals((double)-163.2, (double)ObjectUtils.getFloat((Object)value, (Float)Float.valueOf(-1.0f)), (double)0.1f);
        value = null;
        Assert.assertEquals((double)-1.0, (double)ObjectUtils.getFloat((Object)value, (Float)Float.valueOf(-1.0f)), (double)0.1f);
    }

    @Test
    public void testDoubleConversion() throws Exception {
        Object value = "123.34";
        Assert.assertEquals((double)123.34, (double)ObjectUtils.getDouble((Object)value, (Double)-1.0), (double)0.1);
        value = "xyz";
        Assert.assertEquals((double)-1.0, (double)ObjectUtils.getDouble((Object)value, (Double)-1.0), (double)0.1);
        value = new Integer(6);
        Assert.assertEquals((double)6.0, (double)ObjectUtils.getDouble((Object)value, (Double)-1.0), (double)0.1);
        value = new Double(63.4);
        Assert.assertEquals((double)63.4, (double)ObjectUtils.getDouble((Object)value, (Double)-1.0), (double)0.1);
        value = new Float(-163.2);
        Assert.assertEquals((double)-163.2, (double)ObjectUtils.getDouble((Object)value, (Double)-1.0), (double)0.1);
        value = null;
        Assert.assertEquals((double)-1.0, (double)ObjectUtils.getDouble((Object)value, (Double)-1.0), (double)0.1);
    }

    @Test
    public void testStringConversion() throws Exception {
        Object value = "hello";
        Assert.assertEquals((Object)"hello", (Object)ObjectUtils.getString((Object)value, (String)"x"));
        value = new HashMap();
        Assert.assertEquals((Object)new HashMap().toString(), (Object)ObjectUtils.getString((Object)value, (String)"x"));
        value = null;
        Assert.assertEquals((Object)"x", (Object)ObjectUtils.getString((Object)value, (String)"x"));
    }
}

