/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.ExceptionUtils;

@SmallTest
public class ExceptionUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testContainsType() {
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new IllegalArgumentException(), IllegalArgumentException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException()), IllegalArgumentException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), NullPointerException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), RuntimeException.class));
        Assert.assertTrue((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), Exception.class));
        Assert.assertFalse((boolean)ExceptionUtils.containsType((Throwable)new Exception(new IllegalArgumentException(new NullPointerException())), IOException.class));
    }

    @Test
    public void testLastIndexOfType_deepestIsTheOneWeWant() throws Exception {
        IllegalArgumentException expected = new IllegalArgumentException("something");
        this.assertExpectationsForDeepestOccurence(expected);
    }

    @Test
    public void testLastIndexOfType_theOneWeWantIsNotTheDeepest() throws Exception {
        IllegalArgumentException expected = new IllegalArgumentException("something", new NullPointerException("somenull"));
        this.assertExpectationsForDeepestOccurence(expected);
    }

    private void assertExpectationsForDeepestOccurence(IllegalArgumentException expected) {
        Assert.assertSame((Object)expected, (Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)expected, IllegalArgumentException.class));
        Assert.assertSame((Object)expected, (Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)new Exception(expected), IllegalArgumentException.class));
        Assert.assertSame((Object)expected, (Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)new IllegalArgumentException(new Exception(expected)), IllegalArgumentException.class));
        Assert.assertNull((Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)new IllegalArgumentException(new Exception(expected)), IOException.class));
    }

    @Test
    public void testLastIndexOfType_nullParameters() throws Exception {
        Assert.assertNull((Object)ExceptionUtils.getDeepestOccurenceOfType(null, null));
        Assert.assertNull((Object)ExceptionUtils.getDeepestOccurenceOfType((Throwable)new Exception(), null));
        Assert.assertNull((Object)ExceptionUtils.getDeepestOccurenceOfType(null, Exception.class));
    }

    @Test
    public void testFullStackTraceWithoutMessage() throws Exception {
        String mainMessage = "main message 112312 [][] ''' ... sdfsd blah";
        String causeMessage = "cause message 2342998n  fwefoskjdcas  sdcasdhfsadjgsadkgasd \t\nsdfsllki";
        String lineSeparator = System.getProperty("line.separator");
        RuntimeException e = new RuntimeException("main message 112312 [][] ''' ... sdfsd blah", new RuntimeException("cause message 2342998n  fwefoskjdcas  sdcasdhfsadjgsadkgasd \t\nsdfsllki"));
        String withoutMessage = ExceptionUtils.getFullStackTraceWithoutMessages((Throwable)e);
        String fullStackTrace = org.apache.commons.lang.exception.ExceptionUtils.getFullStackTrace((Throwable)e);
        String[] linesWithoutMessage = withoutMessage.split(lineSeparator);
        String[] lines = fullStackTrace.split(lineSeparator);
        Assert.assertEquals((long)lines.length, (long)linesWithoutMessage.length);
        for (int i = 0; i < lines.length; ++i) {
            Assert.assertTrue((boolean)lines[i].contains(linesWithoutMessage[i]));
            Assert.assertFalse((boolean)linesWithoutMessage[i].contains("main message 112312 [][] ''' ... sdfsd blah"));
            Assert.assertFalse((boolean)linesWithoutMessage[i].contains("cause message 2342998n  fwefoskjdcas  sdcasdhfsadjgsadkgasd \t\nsdfsllki"));
        }
    }
}

