/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.CollectionUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

@SmallTest
public class CollectionUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testToArrayOfComponentTypeNullCollection() {
        Assert.assertNull((Object)CollectionUtils.toArrayOfComponentType(null, String.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToArrayOfComponentTypeNullType() {
        CollectionUtils.toArrayOfComponentType((Collection)Collections.EMPTY_LIST, null);
    }

    @Test
    public void testToArrayOfComponentTypeEmptyCollection() {
        Assert.assertTrue((boolean)Arrays.equals(new String[0], CollectionUtils.toArrayOfComponentType((Collection)Collections.EMPTY_LIST, String.class)));
    }

    @Test(expected=ArrayStoreException.class)
    public void testToArrayOfComponentTypeWrongElement() {
        CollectionUtils.toArrayOfComponentType(Collections.singleton("foo"), Integer.class);
    }

    @Test
    public void testToArrayOfComponentTypeOK() {
        Object[] objects = new String[]{"foo", "bar", "baz"};
        Assert.assertTrue((boolean)Arrays.equals(objects, CollectionUtils.toArrayOfComponentType(Arrays.asList(objects), String.class)));
    }

    @Test
    public void testToStringNull() throws Exception {
        Collection c = null;
        Assert.assertEquals((Object)"[]", (Object)CollectionUtils.toString(c, (boolean)false));
        Assert.assertEquals((Object)"[]", (Object)CollectionUtils.toString(c, (boolean)true));
    }

    @Test
    public void testToStringEmpty() throws Exception {
        ArrayList c = new ArrayList();
        Assert.assertEquals((Object)"[]", (Object)CollectionUtils.toString(c, (boolean)false));
        Assert.assertEquals((Object)"[]", (Object)CollectionUtils.toString(c, (boolean)true));
    }

    @Test
    public void testToStringSingleElement() throws Exception {
        List<String> c = Arrays.asList("foo");
        Assert.assertEquals((Object)"[foo]", (Object)CollectionUtils.toString(c, (boolean)false));
        Assert.assertEquals((Object)("[" + SystemUtils.LINE_SEPARATOR + "foo" + SystemUtils.LINE_SEPARATOR + "]"), (Object)CollectionUtils.toString(c, (boolean)true));
    }

    @Test
    public void testToStringMultipleElements() throws Exception {
        List<Serializable> c = Arrays.asList("foo", this.getClass());
        Assert.assertEquals((Object)("[foo, " + this.getClass().getName() + "]"), (Object)CollectionUtils.toString(c, (boolean)false));
        Assert.assertEquals((Object)("[" + SystemUtils.LINE_SEPARATOR + "foo" + SystemUtils.LINE_SEPARATOR + this.getClass().getName() + SystemUtils.LINE_SEPARATOR + "]"), (Object)CollectionUtils.toString(c, (boolean)true));
    }

    @Test
    public void testToStringTooManyElements() {
        ArrayList<Integer> test = new ArrayList<Integer>(100);
        for (int i = 0; i < 100; ++i) {
            test.add(new Integer(i));
        }
        String result = CollectionUtils.toString(test, (int)10);
        Assert.assertTrue((boolean)result.endsWith("[..]]"));
        Assert.assertEquals((long)9L, (long)StringUtils.countMatches((String)result, (String)","));
    }

    @Test
    public void testContainsTypeTrue() {
        ArrayList<Object> c = new ArrayList<Object>();
        c.add(new String());
        c.add(new Date());
        Assert.assertTrue((boolean)CollectionUtils.containsType(c, Date.class));
    }

    @Test
    public void testContainsTypeFalse() {
        ArrayList<Object> c = new ArrayList<Object>();
        c.add(new String());
        c.add(new Integer(1));
        junit.framework.Assert.assertFalse((boolean)CollectionUtils.containsType(c, Date.class));
    }

    @Test
    public void testContainsTypeNullChecks() {
        ArrayList<Object> c = new ArrayList<Object>();
        c.add(new String());
        c.add(new Integer(1));
        junit.framework.Assert.assertFalse((boolean)CollectionUtils.containsType(c, null));
        junit.framework.Assert.assertFalse((boolean)CollectionUtils.containsType(null, Date.class));
    }

    @Test
    public void testRemoveType() {
        ArrayList<Object> c = new ArrayList<Object>();
        c.add(new String());
        c.add(new Integer(1));
        CollectionUtils.removeType(c, String.class);
        Assert.assertEquals((long)1L, (long)c.size());
        junit.framework.Assert.assertFalse((boolean)CollectionUtils.containsType(c, null));
        junit.framework.Assert.assertFalse((boolean)CollectionUtils.containsType(null, Date.class));
    }
}

