/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.graph;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.registry.ResolverException;
import org.mule.api.transformer.Converter;
import org.mule.api.transformer.DataType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.builder.MockConverterBuilder;
import org.mule.transformer.graph.NameConverterFilter;

@SmallTest
public class NameTransformerFilterTestCase
extends AbstractMuleTestCase {
    private NameConverterFilter filter = new NameConverterFilter();
    private static final DataType<?> UNUSED_DATA_TYPE = null;

    @Test
    public void filtersEmptyList() throws ResolverException {
        ArrayList availableConverters = new ArrayList();
        List converters = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)0, (int)converters.size());
    }

    @Test
    public void filtersEqualName() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToString);
        availableConverters.add(xmlToString);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)2, (int)transformers.size());
        junit.framework.Assert.assertEquals((Object)xmlToString, transformers.get(0));
        junit.framework.Assert.assertEquals((Object)xmlToString, transformers.get(1));
    }

    @Test
    public void filtersDifferentNameWithBetterTransformerFist() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).build();
        Converter stringToJson = ((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(stringToJson);
        availableConverters.add(xmlToString);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)transformers.size());
        Assert.assertTrue((boolean)transformers.contains(stringToJson));
    }

    @Test
    public void filtersDifferentNameWithBetterTransformerLast() throws ResolverException {
        Converter xmlToString = ((MockConverterBuilder)new MockConverterBuilder().named("xmlToString")).build();
        Converter stringToJson = ((MockConverterBuilder)new MockConverterBuilder().named("stringToJson")).build();
        ArrayList<Converter> availableConverters = new ArrayList<Converter>();
        availableConverters.add(xmlToString);
        availableConverters.add(stringToJson);
        List transformers = this.filter.filter(availableConverters, UNUSED_DATA_TYPE, UNUSED_DATA_TYPE);
        junit.framework.Assert.assertEquals((int)1, (int)transformers.size());
        Assert.assertTrue((boolean)transformers.contains(stringToJson));
    }
}

