/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.correlation;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.DefaultMessageCollection;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.routing.EventGroup;
import org.mule.routing.correlation.CorrelationTimeoutException;
import org.mule.routing.correlation.EventCorrelator;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.size.SmallTest;
import org.mule.util.store.SimpleMemoryObjectStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class EventCorrelatorTestCase
extends AbstractMuleTestCase {
    public static final String OBJECT_STOR_NAME_PREFIX = "prefix";
    public static final String TEST_GROUP_ID = "groupId";
    public static final boolean USE_PERSISTENT_STORE = false;
    private static final Logger logger = LoggerFactory.getLogger(EventCorrelatorTestCase.class);
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private EventCorrelatorCallback mockEventCorrelatorCallback;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageProcessor mockTimeoutMessageProcessor;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageInfoMapping mockMessagingInfoMapping;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext mockMuleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ObjectStoreManager mockObjectStoreManager;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private EventGroup mockEventGroup;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ListableObjectStore mockExpireGroupsObjectStore;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ListableObjectStore mockProcessedGroups;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private DefaultMessageCollection mockMessageCollection;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleEvent mockMuleEvent;
    private ListableObjectStore<EventGroup> memoryObjectStore = new SimpleMemoryObjectStore();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=CorrelationTimeoutException.class)
    public void initAfterDeserializationAfterForceGroupExpiry() throws Exception {
        try {
            EventCorrelator eventCorrelator = this.createEventCorrelator();
            eventCorrelator.forceGroupExpiry(TEST_GROUP_ID);
        }
        finally {
            ((EventGroup)Mockito.verify((Object)this.mockEventGroup, (VerificationMode)Mockito.times((int)1))).initAfterDeserialisation(this.mockMuleContext);
        }
    }

    @Test
    public void initAfterDeserializationAfterAddEventGroup() throws Exception {
        EventCorrelator eventCorrelator = this.createEventCorrelator();
        eventCorrelator.addEventGroup(this.mockEventGroup);
        ((EventGroup)Mockito.verify((Object)this.mockEventGroup, (VerificationMode)Mockito.times((int)1))).initAfterDeserialisation(this.mockMuleContext);
    }

    @Test
    public void initAfterDeserializationAfterProcess() throws Exception {
        Mockito.when((Object)this.mockMessagingInfoMapping.getCorrelationId((MuleMessage)Mockito.isA(MuleMessage.class))).thenReturn((Object)TEST_GROUP_ID);
        Mockito.when((Object)this.mockProcessedGroups.contains((Serializable)((Object)TEST_GROUP_ID))).thenReturn((Object)false);
        Mockito.when((Object)this.mockEventCorrelatorCallback.shouldAggregateEvents(this.mockEventGroup)).thenReturn((Object)false);
        EventCorrelator eventCorrelator = this.createEventCorrelator();
        eventCorrelator.process(this.mockMuleEvent);
        ((EventGroup)Mockito.verify((Object)this.mockEventGroup, (VerificationMode)Mockito.times((int)1))).initAfterDeserialisation(this.mockMuleContext);
    }

    @Test
    public void disposeObjectStoresIfDisposable() throws Exception {
        this.mockExpireGroupsObjectStore = (ListableObjectStore)Mockito.mock(DisposableListableObjectStore.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockProcessedGroups = (ListableObjectStore)Mockito.mock(DisposableListableObjectStore.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        EventCorrelator eventCorrelator = this.createEventCorrelator();
        eventCorrelator.dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.mockExpireGroupsObjectStore), (VerificationMode)Mockito.times((int)1))).dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.mockProcessedGroups), (VerificationMode)Mockito.times((int)1))).dispose();
    }

    @Test
    public void processesExpiredGroupInPrimaryNode() throws Exception {
        this.doExpiredGroupMonitoringTest(true);
    }

    @Test
    public void doesNotProcessExpiredGroupInSecondaryNode() throws Exception {
        try {
            this.doExpiredGroupMonitoringTest(false);
            Assert.fail((String)"Expiring group monitoring thread is not supposed to do any work on a secondary node");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExpiredGroupMonitoringTest(boolean primaryNode) throws Exception {
        Mockito.when((Object)this.mockMuleContext.isPrimaryPollingInstance()).thenReturn((Object)primaryNode);
        EventCorrelator eventCorrelator = this.createEventCorrelator();
        Mockito.when((Object)this.mockEventCorrelatorCallback.createEventGroup(this.mockMuleEvent, (Object)TEST_GROUP_ID)).thenReturn((Object)this.mockEventGroup);
        eventCorrelator.start();
        try {
            PollingProber prober = new PollingProber(1000L, 50L);
            prober.check(new Probe(){

                @Override
                public boolean isSatisfied() {
                    try {
                        return !EventCorrelatorTestCase.this.memoryObjectStore.contains((Serializable)((Object)EventCorrelatorTestCase.TEST_GROUP_ID));
                    }
                    catch (ObjectStoreException e) {
                        logger.debug("Could not access object store.");
                        return false;
                    }
                }

                @Override
                public String describeFailure() {
                    return "Event group not expired.";
                }
            });
        }
        finally {
            eventCorrelator.stop();
            eventCorrelator.dispose();
        }
    }

    private EventCorrelator createEventCorrelator() throws Exception {
        Mockito.when((Object)this.mockMuleContext.getRegistry().get("_muleObjectStoreManager")).thenReturn((Object)this.mockObjectStoreManager);
        Mockito.when((Object)this.mockObjectStoreManager.getObjectStore("prefix.expiredAndDispatchedGroups", false)).thenReturn((Object)this.mockExpireGroupsObjectStore);
        Mockito.when((Object)this.mockObjectStoreManager.getObjectStore("prefix.processedGroups", false, 50000, -1, 1000)).thenReturn((Object)this.mockProcessedGroups);
        ((ObjectStoreManager)Mockito.doReturn(this.memoryObjectStore).when((Object)this.mockObjectStoreManager)).getObjectStore("prefix.eventGroups", false);
        this.memoryObjectStore.store((Serializable)((Object)TEST_GROUP_ID), (Serializable)this.mockEventGroup);
        Mockito.when((Object)this.mockEventGroup.getGroupId()).thenReturn((Object)TEST_GROUP_ID);
        Mockito.when((Object)this.mockEventGroup.toMessageCollection()).thenReturn(null);
        return new EventCorrelator(this.mockEventCorrelatorCallback, this.mockTimeoutMessageProcessor, this.mockMessagingInfoMapping, this.mockMuleContext, "flowName", false, OBJECT_STOR_NAME_PREFIX);
    }

    public static interface DisposableListableObjectStore
    extends ListableObjectStore,
    Disposable {
    }
}

