/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.junit.Assert;
import org.junit.Test;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.security.SecurityFilter;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.processor.SecurityFilterMessageProcessor;
import org.mule.tck.security.TestSecurityFilter;

public class SecurityFilterMessageProcessorTestCase
extends AbstractMessageProcessorTestCase {
    @Test
    public void testFilterPass() throws Exception {
        TestSecurityFilter securityFilter = new TestSecurityFilter(true);
        InboundEndpoint endpoint = this.createTestInboundEndpoint(null, (SecurityFilter)securityFilter, MessageExchangePattern.REQUEST_RESPONSE, null);
        SecurityFilterMessageProcessor mp = new SecurityFilterMessageProcessor((SecurityFilter)securityFilter);
        AbstractMessageProcessorTestCase.TestListener listner = new AbstractMessageProcessorTestCase.TestListener();
        mp.setListener((MessageProcessor)listner);
        MuleEvent inEvent = this.createTestInboundEvent(endpoint);
        MuleEvent resultEvent = mp.process(inEvent);
        Assert.assertNotNull((Object)listner.sensedEvent);
        Assert.assertSame((Object)inEvent, (Object)listner.sensedEvent);
        Assert.assertEquals((Object)inEvent, (Object)resultEvent);
    }

    @Test
    public void testFilterFail() throws Exception {
        TestSecurityFilter securityFilter = new TestSecurityFilter(false);
        InboundEndpoint endpoint = this.createTestInboundEndpoint(null, (SecurityFilter)securityFilter, MessageExchangePattern.REQUEST_RESPONSE, null);
        SecurityFilterMessageProcessor mp = new SecurityFilterMessageProcessor((SecurityFilter)securityFilter);
        AbstractMessageProcessorTestCase.TestListener listner = new AbstractMessageProcessorTestCase.TestListener();
        mp.setListener((MessageProcessor)listner);
        MuleEvent inEvent = this.createTestInboundEvent(endpoint);
        RequestContext.setEvent((MuleEvent)inEvent);
        try {
            mp.process(inEvent);
            Assert.fail((String)"Exception expected");
        }
        catch (TestSecurityFilter.StaticMessageUnauthorisedException e) {
            // empty catch block
        }
        Assert.assertNull((Object)listner.sensedEvent);
    }
}

