/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.model;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.model.InvocationResult;
import org.mule.api.transport.PropertyScope;
import org.mule.model.resolvers.MethodHeaderPropertyEntryPointResolver;
import org.mule.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.transport.NullPayload;

public class MethodHeaderEntryPointResolverTestCase
extends AbstractMuleContextTestCase {
    private MethodHeaderPropertyEntryPointResolver resolver;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.resolver = new MethodHeaderPropertyEntryPointResolver();
    }

    @Test
    public void testMethodSetPass() throws Exception {
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext("blah");
        ctx.getMessage().setProperty("method", (Object)"someBusinessMethod", PropertyScope.INBOUND);
        InvocationResult result = this.resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx);
        this.assertInvocationWasSuccessful(result);
    }

    @Test
    public void testMethodSetWithNoArgsPass() throws Exception {
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext(NullPayload.getInstance());
        ctx.getMessage().setProperty("method", (Object)"wash", PropertyScope.INBOUND);
        InvocationResult result = this.resolver.invoke((Object)new Apple(), ctx);
        this.assertInvocationWasSuccessful(result);
        Assert.assertEquals((Object)"wash", (Object)result.getMethodCalled());
    }

    @Test
    public void testCustomMethodProperty() throws Exception {
        this.resolver.setMethodProperty("serviceMethod");
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext("blah");
        ctx.getMessage().setProperty("serviceMethod", (Object)"someBusinessMethod", PropertyScope.INBOUND);
        InvocationResult result = this.resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx);
        this.assertInvocationWasSuccessful(result);
    }

    @Test
    public void testCustomMethodPropertyFail() throws Exception {
        this.resolver.setMethodProperty("serviceMethod");
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext("blah");
        ctx.getMessage().setProperty("serviceMethod", (Object)"noMethod", PropertyScope.INBOUND);
        InvocationResult result = this.resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx);
        this.assertInvocationFailed(result);
    }

    @Test
    public void testMethodPropertyFail() throws Exception {
        this.resolver.setMethodProperty("serviceMethod");
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext("blah");
        ctx.getMessage().setProperty("myMethod", (Object)"someBusinessMethod", PropertyScope.INBOUND);
        InvocationResult result = this.resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx);
        this.assertInvocationFailed(result);
    }

    @Test
    public void testMethodPropertyMismatch() throws Exception {
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext("blah");
        ctx.getMessage().setProperty("method", (Object)"noMethod", PropertyScope.INBOUND);
        InvocationResult result = this.resolver.invoke((Object)new MultiplePayloadsTestObject(), ctx);
        this.assertInvocationFailed(result);
    }

    @Test
    public void testMethodPropertyParameterAssignableFromPayload() throws Exception {
        MuleEventContext ctx = MethodHeaderEntryPointResolverTestCase.getTestEventContext(new Apple());
        ctx.getMessage().setProperty("method", (Object)"wash", PropertyScope.INBOUND);
        InvocationResult result = this.resolver.invoke((Object)new TestFruitCleaner(), ctx);
        this.assertInvocationWasSuccessful(result);
    }

    private void assertInvocationWasSuccessful(InvocationResult result) {
        Assert.assertEquals((Object)InvocationResult.State.SUCCESSFUL, (Object)result.getState());
    }

    private void assertInvocationFailed(InvocationResult result) {
        Assert.assertEquals((Object)InvocationResult.State.FAILED, (Object)result.getState());
    }

    public static class TestFruitCleaner {
        public void wash(Fruit fruit) {
        }

        public void polish(Fruit fruit) {
        }
    }
}

